/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoomInfoTest {
    @Test
    public void validateRoomWithEmptyForm() {
        DataForm dataForm = DataForm.builder((DataForm.Type)DataForm.Type.result).build();
        DiscoverInfo discoInfo = ((DiscoverInfoBuilder)DiscoverInfo.builder((String)"disco1").addExtension((ExtensionElement)dataForm)).build();
        RoomInfo roomInfo = new RoomInfo(discoInfo);
        Assertions.assertTrue((boolean)roomInfo.getDescription().isEmpty());
        Assertions.assertTrue((boolean)roomInfo.getSubject().isEmpty());
        Assertions.assertEquals((int)-1, (int)roomInfo.getOccupantsCount());
    }

    @Test
    public void validateRoomWithForm() {
        DataForm.Builder dataForm = DataForm.builder((DataForm.Type)DataForm.Type.result);
        TextSingleFormField.Builder desc = FormField.builder((String)"muc#roominfo_description");
        desc.setValue((CharSequence)"The place for all good witches!");
        dataForm.addField((FormField)desc.build());
        TextSingleFormField.Builder subject = FormField.builder((String)"muc#roominfo_subject");
        subject.setValue((CharSequence)"Spells");
        dataForm.addField((FormField)subject.build());
        TextSingleFormField.Builder occupants = FormField.builder((String)"muc#roominfo_occupants");
        occupants.setValue((CharSequence)"3");
        dataForm.addField((FormField)occupants.build());
        DiscoverInfo discoInfo = ((DiscoverInfoBuilder)DiscoverInfo.builder((String)"disco1").addExtension((ExtensionElement)dataForm.build())).build();
        RoomInfo roomInfo = new RoomInfo(discoInfo);
        Assertions.assertEquals((Object)"The place for all good witches!", (Object)roomInfo.getDescription());
        Assertions.assertEquals((Object)"Spells", (Object)roomInfo.getSubject());
        Assertions.assertEquals((int)3, (int)roomInfo.getOccupantsCount());
    }
}

