/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.impl.JidCreate;

public class OpenTest
extends SmackTestSuite {
    private static final Properties outputProperties = new Properties();

    public OpenTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test
    public void shouldNotInstantiateWithInvalidArguments1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Open(null, 1));
    }

    @Test
    public void shouldNotInstantiateWithInvalidArguments2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Open("", 1));
    }

    @Test
    public void shouldNotInstantiateWithInvalidArguments3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Open("sessionID", -1));
    }

    @Test
    public void shouldSetIQStanzaAsDefault() {
        Open open = new Open("sessionID", 4096);
        Assertions.assertEquals((Object)InBandBytestreamManager.StanzaType.IQ, (Object)open.getStanza());
    }

    @Test
    public void shouldUseMessageStanzaIfGiven() {
        Open open = new Open("sessionID", 4096, InBandBytestreamManager.StanzaType.MESSAGE);
        Assertions.assertEquals((Object)InBandBytestreamManager.StanzaType.MESSAGE, (Object)open.getStanza());
    }

    @Test
    public void shouldBeOfIQTypeSET() {
        Open open = new Open("sessionID", 4096);
        Assertions.assertEquals((Object)IQ.Type.set, (Object)open.getType());
    }

    @Test
    public void shouldSetAllFieldsCorrectly() {
        Open open = new Open("sessionID", 4096, InBandBytestreamManager.StanzaType.MESSAGE);
        Assertions.assertEquals((Object)"sessionID", (Object)open.getSessionID());
        Assertions.assertEquals((int)4096, (int)open.getBlockSize());
        Assertions.assertEquals((Object)InBandBytestreamManager.StanzaType.MESSAGE, (Object)open.getStanza());
    }

    @Test
    public void shouldReturnValidIQStanzaXML() throws Exception {
        String control = XMLBuilder.create((String)"iq").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "jn3h8g65").a("type", "set").e("open").a("xmlns", "http://jabber.org/protocol/ibb").a("block-size", "4096").a("sid", "i781hf64").a("stanza", "iq").asString(outputProperties);
        Open open = new Open("i781hf64", 4096, InBandBytestreamManager.StanzaType.IQ);
        open.setFrom(JidCreate.from((String)"romeo@montague.lit/orchard"));
        open.setTo(JidCreate.from((String)"juliet@capulet.lit/balcony"));
        open.setStanzaId("jn3h8g65");
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)open.toXML("jabber:client").toString());
    }
}

