/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JingleContentTest
extends SmackTestSuite {
    @Test
    public void emptyBuilderThrowsTest() {
        JingleContent.Builder builder = JingleContent.getBuilder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.build());
    }

    @Test
    public void onlyCreatorBuilderThrowsTest() {
        JingleContent.Builder builder = JingleContent.getBuilder();
        builder.setCreator(JingleContent.Creator.initiator);
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.build());
    }

    @Test
    public void parserTest() throws Exception {
        JingleContent.Builder builder = JingleContent.getBuilder();
        builder.setCreator(JingleContent.Creator.initiator);
        builder.setName("A name");
        JingleContent content = builder.build();
        Assertions.assertNotNull((Object)content);
        Assertions.assertNull((Object)content.getDescription());
        Assertions.assertEquals((Object)JingleContent.Creator.initiator, (Object)content.getCreator());
        Assertions.assertEquals((Object)"A name", (Object)content.getName());
        builder.setSenders(JingleContent.Senders.both);
        content = builder.build();
        Assertions.assertEquals((Object)JingleContent.Senders.both, (Object)content.getSenders());
        builder.setDisposition("session");
        JingleContent content1 = builder.build();
        Assertions.assertEquals((Object)"session", (Object)content1.getDisposition());
        Assertions.assertNotSame((Object)content.toXML().toString(), (Object)content1.toXML().toString());
        Assertions.assertEquals((Object)content1.toXML().toString(), (Object)builder.build().toXML().toString());
        String xml = "<content xmlns='urn:xmpp:jingle:1' creator='initiator' disposition='session' name='A name' senders='both'></content>";
        Assertions.assertEquals((Object)xml, (Object)content1.toXML().toString());
    }
}

