/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_ibb;

import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.element.JingleIBBTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.provider.JingleIBBTransportProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JingleIBBTransportTest
extends SmackTestSuite {
    @Test
    public void parserTest() throws Exception {
        String sid = StringUtils.randomString((int)24);
        short size = 8192;
        String xml = "<transport xmlns='urn:xmpp:jingle:transports:ibb:1' block-size='8192' sid='" + sid + "'/>";
        JingleIBBTransport transport = new JingleIBBTransport(size, sid);
        Assertions.assertEquals((Object)xml, (Object)transport.toXML().toString());
        Assertions.assertEquals((short)size, (short)transport.getBlockSize());
        Assertions.assertEquals((Object)sid, (Object)transport.getSessionId());
        JingleIBBTransport parsed = (JingleIBBTransport)new JingleIBBTransportProvider().parse(TestUtils.getParser((String)xml));
        Assertions.assertEquals((Object)transport, (Object)parsed);
        Assertions.assertTrue((boolean)transport.equals((Object)parsed));
        Assertions.assertEquals((Object)xml, (Object)parsed.toXML().toString());
        JingleIBBTransport transport1 = new JingleIBBTransport(1024);
        Assertions.assertEquals((short)1024, (short)transport1.getBlockSize());
        Assertions.assertNotSame((Object)transport, (Object)transport1);
        Assertions.assertNotSame((Object)transport.getSessionId(), (Object)transport1.getSessionId());
        Assertions.assertFalse((boolean)transport.equals(null));
        JingleIBBTransport transport2 = new JingleIBBTransport();
        Assertions.assertEquals((short)4096, (short)transport2.getBlockSize());
        Assertions.assertFalse((boolean)transport1.equals((Object)transport2));
        JingleIBBTransport transport3 = new JingleIBBTransport(-1024);
        Assertions.assertEquals((short)4096, (short)transport3.getBlockSize());
        Assertions.assertEquals((Object)transport3.getNamespace(), (Object)"urn:xmpp:jingle:transports:ibb:1");
        Assertions.assertEquals((Object)transport3.getElementName(), (Object)"transport");
        JingleIBBTransport transport4 = new JingleIBBTransport("session-id");
        Assertions.assertEquals((short)4096, (short)transport4.getBlockSize());
    }
}

