/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.last_interaction;

import java.util.Date;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.last_interaction.element.IdleElement;
import org.jivesoftware.smackx.last_interaction.provider.IdleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.util.XmppDateTime;

public class IdleTest
extends SmackTestSuite {
    @Test
    public void providerTest() throws Exception {
        String xml = "<idle xmlns='urn:xmpp:idle:1' since='1969-07-21T02:56:15Z' />";
        XmlPullParser parser = TestUtils.getParser((String)xml);
        Assertions.assertNotNull((Object)parser);
        IdleElement parsed = (IdleElement)IdleProvider.TEST_INSTANCE.parse(parser);
        Date date = XmppDateTime.parseXEP0082Date((String)"1969-07-21T02:56:15Z");
        Assertions.assertEquals((Object)date, (Object)parsed.getSince());
        IdleElement element = new IdleElement(date);
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<idle xmlns='urn:xmpp:idle:1' since='1969-07-21T02:56:15.000+00:00'/>", (CharSequence)element.toXML().toString());
    }

    @Test
    public void helperTest() {
        Presence presence = StanzaBuilder.buildPresence().ofType(Presence.Type.available).build();
        IdleElement.addToPresence((Presence)presence);
        IdleElement element = IdleElement.fromPresence((Presence)presence);
        Assertions.assertNotNull((Object)element);
    }
}

