/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.softwareinfo;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.softwareinfo.SoftwareInfoManager;
import org.jivesoftware.smackx.softwareinfo.form.SoftwareInfoForm;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.JidTestUtil;

public class SoftwareInfoManagerTest {
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private XMPPConnection connection;
    private Protocol protocol;

    @BeforeEach
    public void setup() throws XMPPException, SmackException, InterruptedException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection((Protocol)this.protocol, (EntityFullJid)initiatorJID);
    }

    @Test
    public void softwareInfoManagerTest() throws IOException, XmlPullParserException, SmackParsingException, URISyntaxException {
        SoftwareInfoManager manager = SoftwareInfoManager.getInstanceFor((XMPPConnection)this.connection);
        manager.publishSoftwareInformationForm(SoftwareInfoManagerTest.buildSoftwareInfoFormUsingBuilder());
        manager.publishSoftwareInformationForm(SoftwareInfoManagerTest.buildSoftwareInfoFromDataForm());
    }

    public static SoftwareInfoForm buildSoftwareInfoFormUsingBuilder() throws URISyntaxException {
        SoftwareInfoForm.Builder builder = SoftwareInfoForm.getBuilder();
        MediaElement mediaElement = SoftwareInfoManagerTest.createMediaElement();
        builder.setIcon(mediaElement);
        builder.setOS("Windows");
        builder.setOSVersion("XP");
        builder.setSoftware("Exodus");
        builder.setSoftwareVersion("0.9.1");
        return builder.build();
    }

    public static SoftwareInfoForm buildSoftwareInfoFromDataForm() throws URISyntaxException {
        DataForm.Builder dataFormBuilder = DataForm.builder((DataForm.Type)DataForm.Type.result);
        dataFormBuilder.addField((FormField)FormField.buildHiddenFormType((String)"urn:xmpp:dataforms:softwareinfo"));
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"icon").addFormFieldChildElement((FormFieldChildElement)SoftwareInfoManagerTest.createMediaElement())).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"os").setValue((CharSequence)"Windows")).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"os_version").setValue((CharSequence)"XP")).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"software").setValue((CharSequence)"Exodus")).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"software_version").setValue((CharSequence)"0.9.1")).build());
        SoftwareInfoForm softwareInfoForm = SoftwareInfoForm.getBuilder().setDataForm(dataFormBuilder.build()).build();
        return softwareInfoForm;
    }

    public static MediaElement createMediaElement() throws URISyntaxException {
        return MediaElement.builder().addUri(new MediaElement.Uri(new URI("http://example.org"), "test-type")).setHeightAndWidth(16, 16).build();
    }
}

