/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.usertune.element.UserTuneElement;
import org.jivesoftware.smackx.usertune.provider.UserTuneProvider;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class UserTuneElementTest
extends SmackTestSuite {
    private final String xml = "<tune xmlns='http://jabber.org/protocol/tune'><artist>Yes</artist><length>686</length><rating>8</rating><source>Yessongs</source><title>Heart of the Sunrise</title><track>3</track><uri>http://www.yesworld.com/lyrics/Fragile.html#9</uri></tune>";

    @Test
    public void toXmlTest() throws IOException, XmlPullParserException, SmackParsingException, URISyntaxException {
        URI uri = new URI("http://www.yesworld.com/lyrics/Fragile.html#9");
        UserTuneElement.Builder builder = UserTuneElement.getBuilder();
        UserTuneElement userTuneElement = builder.setArtist("Yes").setLength(686).setRating(8).setSource("Yessongs").setTitle("Heart of the Sunrise").setTrack("3").setUri(uri).build();
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<tune xmlns='http://jabber.org/protocol/tune'><artist>Yes</artist><length>686</length><rating>8</rating><source>Yessongs</source><title>Heart of the Sunrise</title><track>3</track><uri>http://www.yesworld.com/lyrics/Fragile.html#9</uri></tune>", (CharSequence)userTuneElement.toXML().toString());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void userTuneElementProviderTest(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        XmlPullParser parser = SmackTestUtil.getParserFor((String)"<tune xmlns='http://jabber.org/protocol/tune'><artist>Yes</artist><length>686</length><rating>8</rating><source>Yessongs</source><title>Heart of the Sunrise</title><track>3</track><uri>http://www.yesworld.com/lyrics/Fragile.html#9</uri></tune>", (SmackTestUtil.XmlPullParserKind)parserKind);
        UserTuneElement parsed = (UserTuneElement)UserTuneProvider.INSTANCE.parse(parser);
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<tune xmlns='http://jabber.org/protocol/tune'><artist>Yes</artist><length>686</length><rating>8</rating><source>Yessongs</source><title>Heart of the Sunrise</title><track>3</track><uri>http://www.yesworld.com/lyrics/Fragile.html#9</uri></tune>", (CharSequence)parsed.toXML().toString());
    }
}

