/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.Whitebox;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.bytestreams.ibb.IBBPacketUtils;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class InBandBytestreamSessionTest
extends SmackTestSuite {
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final String sessionID = "session_id";
    private static final int blockSize = 10;
    private Protocol protocol;
    private XMPPConnection connection;
    private Open initBytestream;
    private Verification<Data, IQ> incrementingSequence;

    @BeforeEach
    public void setup() throws XMPPException, SmackException, InterruptedException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection((Protocol)this.protocol, (EntityFullJid)initiatorJID);
        this.initBytestream = new Open(sessionID, 10);
        this.initBytestream.setFrom((Jid)initiatorJID);
        this.initBytestream.setTo((Jid)targetJID);
        this.incrementingSequence = new Verification<Data, IQ>(){
            long lastSeq = 0L;

            public void verify(Data request, IQ response) {
                Assertions.assertEquals((long)this.lastSeq++, (long)request.getDataPacketExtension().getSeq());
            }
        };
    }

    @Test
    public void shouldSendThreeDataPackets1() throws Exception {
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        byte[] controlData = new byte[30];
        OutputStream outputStream = session.getOutputStream();
        outputStream.write(controlData);
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendThreeDataPackets2() throws Exception {
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        byte[] controlData = new byte[30];
        OutputStream outputStream = session.getOutputStream();
        for (byte b : controlData) {
            outputStream.write(b);
        }
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendThreeDataPackets3() throws Exception {
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        byte[] controlData = new byte[28];
        OutputStream outputStream = session.getOutputStream();
        int off = 0;
        for (int i = 1; i <= 7; ++i) {
            outputStream.write(controlData, off, i);
            off += i;
        }
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendThirtyDataPackets() throws Exception {
        byte[] controlData = new byte[30];
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        for (int i = 0; i < controlData.length; ++i) {
            this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        }
        OutputStream outputStream = session.getOutputStream();
        for (byte b : controlData) {
            outputStream.write(b);
            outputStream.flush();
        }
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendNothingOnSuccessiveCallsToFlush() throws Exception {
        byte[] controlData = new byte[30];
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence});
        OutputStream outputStream = session.getOutputStream();
        outputStream.write(controlData);
        outputStream.flush();
        outputStream.flush();
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendDataCorrectly() throws Exception {
        Random rand = new Random();
        final byte[] controlData = new byte[2560];
        rand.nextBytes(controlData);
        Verification<Data, IQ> dataVerification = new Verification<Data, IQ>(){

            public void verify(Data request, IQ response) {
                byte[] decodedData = request.getDataPacketExtension().getDecodedData();
                int seq = (int)request.getDataPacketExtension().getSeq();
                for (int i = 0; i < decodedData.length; ++i) {
                    Assertions.assertEquals((byte)controlData[seq * 10 + i], (byte)decodedData[i]);
                }
            }
        };
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        for (int i = 0; i < controlData.length / 10; ++i) {
            this.protocol.addResponse((Stanza)resultIQ, new Verification[]{this.incrementingSequence, dataVerification});
        }
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        OutputStream outputStream = session.getOutputStream();
        outputStream.write(controlData);
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldNotCloseBothStreamsIfOutputStreamIsClosed() throws Exception {
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        OutputStream outputStream = session.getOutputStream();
        outputStream.close();
        this.protocol.addResponse(null, new Verification[]{Verification.requestTypeRESULT});
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        String base64Data = Base64.encode((String)"Data");
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 0L, base64Data);
        Data data = new Data(dpe);
        listener.processStanza((Stanza)data);
        this.protocol.verifyAll();
        try {
            outputStream.flush();
            Assertions.fail((String)"should throw an exception");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("closed"));
        }
        Assertions.assertTrue((inputStream.read() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldConfirmReceivedDataPacket() throws Exception {
        this.protocol.addResponse(null, new Verification[]{Verification.requestTypeRESULT});
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        String base64Data = Base64.encode((String)"Data");
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 0L, base64Data);
        Data data = new Data(dpe);
        listener.processStanza((Stanza)data);
        this.protocol.verifyAll();
    }

    @Test
    public void shouldReplyWithErrorIfAlreadyUsedSequenceIsReceived() throws Exception {
        this.protocol.addResponse(null, new Verification[]{Verification.requestTypeRESULT});
        this.protocol.addResponse(null, new Verification[]{Verification.requestTypeERROR, new Verification<IQ, IQ>(){

            public void verify(IQ request, IQ response) {
                Assertions.assertEquals((Object)StanzaError.Condition.unexpected_request, (Object)request.getError().getCondition());
            }
        }});
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        String base64Data = Base64.encode((String)"Data");
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 0L, base64Data);
        Data data1 = new Data(dpe);
        Data data2 = new Data(dpe);
        listener.processStanza((Stanza)data1);
        listener.processStanza((Stanza)data2);
        this.protocol.verifyAll();
    }

    @Test
    public void shouldReplyWithErrorIfDataIsInvalid() throws Exception {
        this.protocol.addResponse(null, new Verification[]{Verification.requestTypeERROR, new Verification<IQ, IQ>(){

            public void verify(IQ request, IQ response) {
                Assertions.assertEquals((Object)StanzaError.Condition.bad_request, (Object)request.getError().getCondition());
            }
        }});
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 0L, "AA=BB");
        Data data = new Data(dpe);
        listener.processStanza((Stanza)data);
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendCloseRequestIfInvalidSequenceReceived() throws Exception {
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[0]);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{Verification.requestTypeSET, Verification.correspondingSenderReceiver});
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        String base64Data = Base64.encode((String)"Data");
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 123L, base64Data);
        Data data = new Data(dpe);
        listener.processStanza((Stanza)data);
        try {
            inputStream.read();
            Assertions.fail((String)"exception should be thrown");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Packets out of sequence"));
        }
        this.protocol.verifyAll();
    }

    @Test
    public void shouldReadAllReceivedData1() throws Exception {
        Random rand = new Random();
        byte[] controlData = new byte[30];
        rand.nextBytes(controlData);
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        for (int i = 0; i < controlData.length / 10; ++i) {
            this.protocol.addResponse((Stanza)resultIQ, new Verification[0]);
            String base64Data = Base64.encodeToString((byte[])controlData, (int)(i * 10), (int)10);
            DataPacketExtension dpe = new DataPacketExtension(sessionID, (long)i, base64Data);
            Data data = new Data(dpe);
            listener.processStanza((Stanza)data);
        }
        byte[] bytes = new byte[30];
        int read = inputStream.read(bytes, 0, 10);
        Assertions.assertEquals((int)10, (int)read);
        read = inputStream.read(bytes, 10, 10);
        Assertions.assertEquals((int)10, (int)read);
        read = inputStream.read(bytes, 20, 10);
        Assertions.assertEquals((int)10, (int)read);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)controlData[i], (byte)bytes[i]);
        }
        this.protocol.verifyAll();
    }

    @Test
    public void shouldReadAllReceivedData2() throws Exception {
        int i;
        Random rand = new Random();
        byte[] controlData = new byte[30];
        rand.nextBytes(controlData);
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        for (int i2 = 0; i2 < controlData.length / 10; ++i2) {
            this.protocol.addResponse((Stanza)resultIQ, new Verification[0]);
            String base64Data = Base64.encodeToString((byte[])controlData, (int)(i2 * 10), (int)10);
            DataPacketExtension dpe = new DataPacketExtension(sessionID, (long)i2, base64Data);
            Data data = new Data(dpe);
            listener.processStanza((Stanza)data);
        }
        byte[] bytes = new byte[30];
        for (i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)inputStream.read();
        }
        for (i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)controlData[i], (byte)bytes[i]);
        }
        this.protocol.verifyAll();
    }

    @Test
    public void shouldNotCloseBothStreamsIfInputStreamIsClosed() throws Exception {
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[0]);
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        String base64Data = Base64.encode((String)"Data");
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 0L, base64Data);
        Data data = new Data(dpe);
        listener.processStanza((Stanza)data);
        inputStream.close();
        this.protocol.verifyAll();
        try {
            while (inputStream.read() != -1) {
            }
            inputStream.read();
            Assertions.fail((String)"should throw an exception");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("closed"));
        }
        session.getOutputStream().flush();
    }

    @Test
    public void shouldNotDeadlockIfInputStreamIsClosed() throws Exception {
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[0]);
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        final InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        String base64Data = Base64.encode((String)"Data");
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 0L, base64Data);
        Data data = new Data(dpe);
        listener.processStanza((Stanza)data);
        Thread closer = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    inputStream.close();
                }
                catch (Exception e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
        });
        closer.start();
        try {
            byte[] bytes = new byte[20];
            while (inputStream.read(bytes) != -1) {
            }
            inputStream.read();
            Assertions.fail((String)"should throw an exception");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("closed"));
        }
        this.protocol.verifyAll();
    }
}

