/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub.provider;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jivesoftware.smack.test.util.CharSequenceEquals;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PubSubProviderTest {
    @Test
    public void subscriptionsOwnerResultTest() throws Exception {
        String resultStanza = "<iq from='pubsub.example.org' to='julia@example.org/Smack' id='HaT4m-13' type='result'><pubsub xmlns='http://jabber.org/protocol/pubsub#owner'><subscriptions node='test'><subscription jid='foo@example.org/Smack' subscription='subscribed' subid='58C1A6F99F2A7'/><subscription jid='julia@example.org/Smack' subscription='subscribed' subid='58C18F8917321'/></subscriptions></pubsub></iq>";
        XmlPullParser parser = TestUtils.getIQParser((String)"<iq from='pubsub.example.org' to='julia@example.org/Smack' id='HaT4m-13' type='result'><pubsub xmlns='http://jabber.org/protocol/pubsub#owner'><subscriptions node='test'><subscription jid='foo@example.org/Smack' subscription='subscribed' subid='58C1A6F99F2A7'/><subscription jid='julia@example.org/Smack' subscription='subscribed' subid='58C18F8917321'/></subscriptions></pubsub></iq>");
        PubSub pubsubResult = (PubSub)PacketParserUtils.parseIQ((XmlPullParser)parser);
        SubscriptionsExtension subElem = (SubscriptionsExtension)pubsubResult.getExtension(PubSubElementType.SUBSCRIPTIONS_OWNER);
        List subscriptions = subElem.getSubscriptions();
        Assertions.assertEquals((int)2, (int)subscriptions.size());
        Subscription sub1 = (Subscription)subscriptions.get(0);
        MatcherAssert.assertThat((Object)"foo@example.org/Smack", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)sub1.getJid()));
        Assertions.assertEquals((Object)Subscription.State.subscribed, (Object)sub1.getState());
        Assertions.assertEquals((Object)"58C1A6F99F2A7", (Object)sub1.getId());
        Subscription sub2 = (Subscription)subscriptions.get(1);
        MatcherAssert.assertThat((Object)"julia@example.org/Smack", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)sub2.getJid()));
        Assertions.assertEquals((Object)Subscription.State.subscribed, (Object)sub2.getState());
        Assertions.assertEquals((Object)"58C18F8917321", (Object)sub2.getId());
    }
}

