/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.blocking;

import java.util.ArrayList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.blocking.element.BlockContactsIQ;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class BlockContactsIQTest {
    private static final String blockContactIQExample = "<iq xmlns='jabber:client' id='block1' type='set'><block xmlns='urn:xmpp:blocking'><item jid='romeo@montague.net'/><item jid='pepe@montague.net'/></block></iq>";
    private static final String blockContactPushIQExample = "<iq xmlns='jabber:client' to='juliet@capulet.com/chamber' type='set' id='push1'><block xmlns='urn:xmpp:blocking'><item jid='romeo@montague.net'/><item jid='pepe@montague.net'/></block></iq>";

    @Test
    public void checkBlockContactIQStanza() throws Exception {
        ArrayList<Jid> jids = new ArrayList<Jid>();
        jids.add(JidCreate.from((String)"romeo@montague.net"));
        jids.add(JidCreate.from((String)"pepe@montague.net"));
        BlockContactsIQ blockContactIQ = new BlockContactsIQ(jids);
        blockContactIQ.setStanzaId("block1");
        Assertions.assertEquals((Object)blockContactIQExample, (Object)blockContactIQ.toXML().toString());
    }

    @Test
    public void checkBlockContactPushIQ() throws Exception {
        IQ iq = (IQ)PacketParserUtils.parseStanza((String)blockContactPushIQExample);
        BlockContactsIQ blockContactIQ = (BlockContactsIQ)iq;
        Assertions.assertEquals((Object)JidCreate.from((String)"romeo@montague.net"), blockContactIQ.getJids().get(0));
        Assertions.assertEquals((Object)JidCreate.from((String)"pepe@montague.net"), blockContactIQ.getJids().get(1));
    }
}

