/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class DataPacketExtension
implements ExtensionElement {
    public static final String ELEMENT = "data";
    public static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final QName QNAME = new QName("http://jabber.org/protocol/ibb", "data");
    private final String sessionID;
    private final UInt16 seq;
    private final String data;
    private byte[] decodedData;

    public DataPacketExtension(String sessionID, int seq, String data) {
        this(sessionID, UInt16.from((int)seq), data);
    }

    public DataPacketExtension(String sessionID, UInt16 seq, String data) {
        if (sessionID == null || "".equals(sessionID)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        this.sessionID = sessionID;
        this.seq = (UInt16)Objects.requireNonNull((Object)seq);
        this.data = data;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public UInt16 getSeq() {
        return this.seq;
    }

    public String getData() {
        return this.data;
    }

    public byte[] getDecodedData() {
        if (this.decodedData != null) {
            return this.decodedData;
        }
        if (this.data.matches(".*={1,2}+.+")) {
            return null;
        }
        this.decodedData = Base64.decode((String)this.data);
        return this.decodedData;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        IQ.IQChildElementXmlStringBuilder xml = this.getIQChildElementBuilder(new IQ.IQChildElementXmlStringBuilder((ExtensionElement)this));
        xml.closeElement((NamedElement)this);
        return xml;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.attribute("seq", (CharSequence)this.seq);
        xml.attribute("sid", this.sessionID);
        xml.rightAngleBracket();
        xml.append((CharSequence)this.data);
        return xml;
    }
}

