/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import com.jamesmurty.utils.XMLBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataPacketExtensionTest
extends SmackTestSuite {
    private static final Properties outputProperties = new Properties();

    public DataPacketExtensionTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test
    public void shouldNotInstantiateWithInvalidArgument1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataPacketExtension(null, 0, "data"));
    }

    @Test
    public void shouldNotInstantiateWithInvalidArgument2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataPacketExtension("", 0, "data"));
    }

    @Test
    public void shouldNotInstantiateWithInvalidArgument3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataPacketExtension("sessionID", -1, "data"));
    }

    @Test
    public void shouldNotInstantiateWithInvalidArgument4() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataPacketExtension("sessionID", 70000, "data"));
    }

    @Test
    public void shouldNotInstantiateWithInvalidArgument5() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataPacketExtension("sessionID", 0, null));
    }

    @Test
    public void shouldSetAllFieldsCorrectly() {
        DataPacketExtension data = new DataPacketExtension("sessionID", 0, "data");
        Assertions.assertEquals((Object)"sessionID", (Object)data.getSessionID());
        Assertions.assertEquals((int)0, (int)data.getSeq().intValue());
        Assertions.assertEquals((Object)"data", (Object)data.getData());
    }

    @Test
    public void shouldReturnNullIfDataIsInvalid() {
        DataPacketExtension data = new DataPacketExtension("sessionID", 0, "BBBB=CCC");
        Assertions.assertNull((Object)data.getDecodedData());
        data = new DataPacketExtension("sessionID", 0, new String(new byte[]{123}, StandardCharsets.UTF_8));
        Assertions.assertNull((Object)data.getDecodedData());
    }

    @Test
    public void shouldReturnValidIQStanzaXML() throws Exception {
        String control = XMLBuilder.create((String)"data").a("xmlns", "http://jabber.org/protocol/ibb").a("seq", "0").a("sid", "i781hf64").t("DATA").asString(outputProperties);
        DataPacketExtension data = new DataPacketExtension("i781hf64", 0, "DATA");
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)data.toXML().toString());
    }
}

