/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5TestProxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class Socks5ClientForInitiatorTest {
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    private static final String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
    private static final int GET_SOCKET_TIMEOUT = 90000;
    private static final String sessionID = "session_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailIfTargetIsNotConnectedToLocalSocks5Proxy() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.start();
        try {
            Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)connection.getUser(), loopbackAddress, socks5Proxy.getPort());
            String digest = Socks5Utils.createDigest((String)sessionID, (Jid)initiatorJID, (Jid)targetJID);
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, connection, sessionID, (Jid)targetJID);
            try {
                socks5Client.getSocket(90000);
                Assertions.fail((String)"exception should be thrown");
            }
            catch (SmackException e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("target is not connected to SOCKS5 proxy"));
                protocol.verifyAll();
            }
        }
        finally {
            socks5Proxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSuccessfullyConnectThroughLocalSocks5Proxy() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.start();
        try {
            final byte[] data = new byte[]{1, 2, 3};
            final String digest = Socks5Utils.createDigest((String)sessionID, (Jid)initiatorJID, (Jid)targetJID);
            socks5Proxy.addTransfer(digest);
            final Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)connection.getUser(), loopbackAddress, socks5Proxy.getPort());
            Thread targetThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Socks5Client targetClient = new Socks5Client(streamHost, digest);
                        Socket socket = targetClient.getSocket(10000);
                        socket.getOutputStream().write(data);
                    }
                    catch (Exception e) {
                        Assertions.fail((String)e.getMessage());
                    }
                }
            };
            targetThread.start();
            Thread.sleep(200L);
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, connection, sessionID, (Jid)targetJID);
            Socket socket = socks5Client.getSocket(90000);
            InputStream in = socket.getInputStream();
            for (int i = 0; i < data.length; ++i) {
                Assertions.assertEquals((int)data[i], (int)in.read());
            }
            targetThread.join();
            protocol.verifyAll();
            socks5Proxy.removeTransfer(digest);
        }
        finally {
            socks5Proxy.stop();
        }
    }

    @Test
    public void shouldFailIfActivateSocks5ProxyFails() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        ErrorIQ error = new ErrorIQ(StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).build());
        error.setFrom((Jid)proxyJID);
        error.setTo((Jid)initiatorJID);
        protocol.addResponse((Stanza)error, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeSET});
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy();){
            Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)proxyJID, loopbackAddress, socks5Proxy.getPort());
            String digest = Socks5Utils.createDigest((String)sessionID, (Jid)initiatorJID, (Jid)targetJID);
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, connection, sessionID, (Jid)targetJID);
            try {
                socks5Client.getSocket(90000);
                Assertions.fail((String)"exception should be thrown");
            }
            catch (XMPPException.XMPPErrorException e) {
                Assertions.assertTrue((boolean)StanzaError.Condition.internal_server_error.equals((Object)e.getStanzaError().getCondition()));
                protocol.verifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSuccessfullyEstablishConnectionAndActivateSocks5Proxy() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        EmptyResultIQ activationResponse = new EmptyResultIQ();
        activationResponse.setFrom((Jid)proxyJID);
        activationResponse.setTo((Jid)initiatorJID);
        protocol.addResponse((Stanza)activationResponse, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeSET, new Verification<Bytestream, IQ>(){

            public void verify(Bytestream request, IQ response) {
                Assertions.assertNotNull((Object)request.getToActivate());
                Assertions.assertEquals((Object)targetJID, (Object)request.getToActivate().getTarget());
            }
        }});
        Socket initiatorSocket = null;
        Socket targetSocket = null;
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy();){
            Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)proxyJID, loopbackAddress, socks5Proxy.getPort());
            String digest = Socks5Utils.createDigest((String)sessionID, (Jid)initiatorJID, (Jid)targetJID);
            Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, connection, sessionID, (Jid)targetJID);
            initiatorSocket = socks5Client.getSocket(10000);
            InputStream in = initiatorSocket.getInputStream();
            targetSocket = socks5Proxy.getSocket(digest);
            OutputStream out = targetSocket.getOutputStream();
            for (int i = 0; i < 10; ++i) {
                out.write(i);
                Assertions.assertEquals((int)i, (int)in.read());
            }
            protocol.verifyAll();
        }
        catch (Throwable throwable) {
            CloseableUtil.maybeClose(initiatorSocket);
            CloseableUtil.maybeClose(targetSocket);
            throw throwable;
        }
        CloseableUtil.maybeClose((Closeable)initiatorSocket);
        CloseableUtil.maybeClose((Closeable)targetSocket);
    }
}

