/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.provider;

import java.net.URI;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.util.XmppDateTime;

public class GeoLocationProviderTest
extends SmackTestSuite {
    @Test
    public void testGeoLocationProviderWithNoDatumSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>");
        Assertions.assertNotNull((Object)messageWithGeoLocation);
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension(GeoLocation.class);
        Assertions.assertNotNull((Object)geoLocation);
        Assertions.assertEquals((Double)23.0, (Double)geoLocation.getAccuracy());
        Assertions.assertEquals((Double)1000.0, (Double)geoLocation.getAlt());
        Assertions.assertEquals((Double)10.0, (Double)geoLocation.getAltAccuracy());
        Assertions.assertEquals((Object)"Delhi", (Object)geoLocation.getArea());
        Assertions.assertEquals((Double)10.0, (Double)geoLocation.getBearing());
        Assertions.assertEquals((Object)"Small Building", (Object)geoLocation.getBuilding());
        Assertions.assertEquals((Object)"India", (Object)geoLocation.getCountry());
        Assertions.assertEquals((Object)"IN", (Object)geoLocation.getCountryCode());
        Assertions.assertEquals((Object)"WGS84", (Object)geoLocation.getDatum());
        Assertions.assertEquals((Object)"My Description", (Object)geoLocation.getDescription());
        Double error = geoLocation.getError();
        Assertions.assertEquals((double)90.0, (Double)error);
        Assertions.assertEquals((Object)"top", (Object)geoLocation.getFloor());
        Assertions.assertEquals((Double)25.098345, (Double)geoLocation.getLat());
        Assertions.assertEquals((Object)"awesome", (Object)geoLocation.getLocality());
        Assertions.assertEquals((Double)77.992034, (Double)geoLocation.getLon());
        Assertions.assertEquals((Object)"110085", (Object)geoLocation.getPostalcode());
        Assertions.assertEquals((Object)"North", (Object)geoLocation.getRegion());
        Assertions.assertEquals((Object)"small", (Object)geoLocation.getRoom());
        Assertions.assertEquals((Double)250.0, (Double)geoLocation.getSpeed());
        Assertions.assertEquals((Object)"Wall Street", (Object)geoLocation.getStreet());
        Assertions.assertEquals((Object)"Unit Testing GeoLocation", (Object)geoLocation.getText());
        Assertions.assertEquals((Object)XmppDateTime.parseDate((String)"2004-02-19"), (Object)geoLocation.getTimestamp());
        Assertions.assertEquals((Object)"+5:30", (Object)geoLocation.getTzo());
        Assertions.assertEquals((Object)new URI("http://xmpp.org"), (Object)geoLocation.getUri());
    }

    @Test
    public void testGeoLocationWithDatumSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><datum>Test Datum</datum><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><datum>Test Datum</datum><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>");
        Assertions.assertNotNull((Object)messageWithGeoLocation);
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension(GeoLocation.class);
        Assertions.assertNotNull((Object)geoLocation);
        Assertions.assertEquals((Double)23.0, (Double)geoLocation.getAccuracy());
        Assertions.assertEquals((Double)1000.0, (Double)geoLocation.getAlt());
        Assertions.assertEquals((Double)10.0, (Double)geoLocation.getAltAccuracy());
        Assertions.assertEquals((Object)"Delhi", (Object)geoLocation.getArea());
        Assertions.assertEquals((Double)10.0, (Double)geoLocation.getBearing());
        Assertions.assertEquals((Object)"Small Building", (Object)geoLocation.getBuilding());
        Assertions.assertEquals((Object)"India", (Object)geoLocation.getCountry());
        Assertions.assertEquals((Object)"IN", (Object)geoLocation.getCountryCode());
        Assertions.assertEquals((Object)"Test Datum", (Object)geoLocation.getDatum());
        Assertions.assertEquals((Object)"My Description", (Object)geoLocation.getDescription());
        Double error = geoLocation.getError();
        Assertions.assertEquals((double)90.0, (Double)error);
        Assertions.assertEquals((Object)"top", (Object)geoLocation.getFloor());
        Assertions.assertEquals((Double)25.098345, (Double)geoLocation.getLat());
        Assertions.assertEquals((Object)"awesome", (Object)geoLocation.getLocality());
        Assertions.assertEquals((Double)77.992034, (Double)geoLocation.getLon());
        Assertions.assertEquals((Object)"110085", (Object)geoLocation.getPostalcode());
        Assertions.assertEquals((Object)"North", (Object)geoLocation.getRegion());
        Assertions.assertEquals((Object)"small", (Object)geoLocation.getRoom());
        Assertions.assertEquals((Double)250.0, (Double)geoLocation.getSpeed());
        Assertions.assertEquals((Object)"Wall Street", (Object)geoLocation.getStreet());
        Assertions.assertEquals((Object)"Unit Testing GeoLocation", (Object)geoLocation.getText());
        Assertions.assertEquals((Object)XmppDateTime.parseDate((String)"2004-02-19"), (Object)geoLocation.getTimestamp());
        Assertions.assertEquals((Object)"+5:30", (Object)geoLocation.getTzo());
        Assertions.assertEquals((Object)new URI("http://xmpp.org"), (Object)geoLocation.getUri());
    }

    @Test
    public void testGeoLocationWithoutAccuracySetAndWithErrorSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><error>90</error></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><error>90</error></geoloc></message>");
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension(GeoLocation.class);
        Double error = geoLocation.getError();
        Assertions.assertEquals((Double)90.0, (Double)error);
    }

    @Test
    public void testGeoLocationWithAccuracySetAndWithoutErrorSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy></geoloc></message>");
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension(GeoLocation.class);
        Assertions.assertEquals((Double)90.0, (Double)geoLocation.getAccuracy());
    }

    @Test
    public void testGeoLocationWithAccuracySetAndErrorSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy><error>100</error></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy><error>100</error></geoloc></message>");
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension(GeoLocation.class);
        Assertions.assertEquals((Double)90.0, (Double)geoLocation.getAccuracy());
        Double error = geoLocation.getError();
        Assertions.assertEquals((double)100.0, (Double)error);
    }
}

