/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.provider;

import java.io.IOException;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JingleProviderTest {
    @Test
    public void testParseUnknownJingleContentDescrption() throws Exception {
        String unknownJingleContentDescriptionNamespace = "urn:xmpp:jingle:unknown-description:5";
        String unknownJingleContentDescription = "<description xmlns='urn:xmpp:jingle:unknown-description:5'><file><date>1969-07-21T02:56:15Z</date><desc>This is a test. If this were a real file...</desc><media-type>text/plain</media-type><name>test.txt</name><range/><size>6144</size><hash xmlns='urn:xmpp:hashes:2' algo='sha-1'>w0mcJylzCn+AfvuGdqkty2+KP48=</hash></file></description>";
        XmlPullParser parser = JingleProviderTest.createTestJingle("<description xmlns='urn:xmpp:jingle:unknown-description:5'><file><date>1969-07-21T02:56:15Z</date><desc>This is a test. If this were a real file...</desc><media-type>text/plain</media-type><name>test.txt</name><range/><size>6144</size><hash xmlns='urn:xmpp:hashes:2' algo='sha-1'>w0mcJylzCn+AfvuGdqkty2+KP48=</hash></file></description>");
        Jingle jingle = (Jingle)PacketParserUtils.parseIQ((XmlPullParser)parser);
        JingleContentDescription jingleContentDescription = jingle.getSoleContentOrThrow().getDescription();
        String parsedUnknownJingleContentDescriptionNamespace = jingleContentDescription.getNamespace();
        Assertions.assertEquals((Object)"urn:xmpp:jingle:unknown-description:5", (Object)parsedUnknownJingleContentDescriptionNamespace);
    }

    @Test
    public void testParseUnknownJingleContentTransport() throws Exception {
        String unknownJingleContentTransportNamespace = "urn:xmpp:jingle:unknown-transport:foo:1";
        String unknownJingleContentTransport = "<transport xmlns='urn:xmpp:jingle:unknown-transport:foo:1' mode='tcp' sid='vj3hs98y'><candidate cid='hft54dqy' host='192.168.4.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5086' priority='8257636' type='direct'/><candidate cid='hutr46fe' host='24.24.24.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5087' priority='8258636' type='direct'/></transport>";
        XmlPullParser parser = JingleProviderTest.createTestJingle("<transport xmlns='urn:xmpp:jingle:unknown-transport:foo:1' mode='tcp' sid='vj3hs98y'><candidate cid='hft54dqy' host='192.168.4.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5086' priority='8257636' type='direct'/><candidate cid='hutr46fe' host='24.24.24.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5087' priority='8258636' type='direct'/></transport>");
        Jingle jingle = (Jingle)PacketParserUtils.parseIQ((XmlPullParser)parser);
        JingleContentTransport jingleContentTransport = jingle.getSoleContentOrThrow().getTransport();
        String parsedUnknownJingleContentTransportNamespace = jingleContentTransport.getNamespace();
        Assertions.assertEquals((Object)"urn:xmpp:jingle:unknown-transport:foo:1", (Object)parsedUnknownJingleContentTransportNamespace);
    }

    private static XmlPullParser createTestJingle(String ... childs) throws XmlPullParserException, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<iq from='romeo@montague.example/dr4hcr0st3lup4c' id='nzu25s8' to='juliet@capulet.example/yn0cl4bnw0yr3vym' type='set'><jingle xmlns='urn:xmpp:jingle:1'  action='session-initiate'  initiator='romeo@montague.example/dr4hcr0st3lup4c'  sid='851ba2'><content creator='initiator' name='a-file-offer' senders='initiator'>");
        for (String child : childs) {
            sb.append(child);
        }
        sb.append("</content></jingle></iq>");
        String jingleStanza = sb.toString();
        XmlPullParser parser = PacketParserUtils.getParserFor((String)jingleStanza);
        return parser;
    }
}

