/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.impl.JidCreate;

public class CloseTest
extends SmackTestSuite {
    private static final Properties outputProperties = new Properties();

    public CloseTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test
    public void shouldNotInstantiateWithInvalidArguments1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Close(null));
    }

    @Test
    public void shouldNotInstantiateWithInvalidArguments2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Close(""));
    }

    @Test
    public void shouldBeOfIQTypeSET() {
        Close close = new Close("sessionID");
        Assertions.assertEquals((Object)IQ.Type.set, (Object)close.getType());
    }

    @Test
    public void shouldSetAllFieldsCorrectly() {
        Close close = new Close("sessionID");
        Assertions.assertEquals((Object)"sessionID", (Object)close.getSessionID());
    }

    @Test
    public void shouldReturnValidIQStanzaXML() throws Exception {
        String control = XMLBuilder.create((String)"iq").a("to", "juliet@capulet.lit/balcony").a("from", "romeo@montague.lit/orchard").a("id", "us71g45j").a("type", "set").e("close").a("xmlns", "http://jabber.org/protocol/ibb").a("sid", "i781hf64").asString(outputProperties);
        Close close = new Close("i781hf64");
        close.setFrom(JidCreate.from((String)"romeo@montague.lit/orchard"));
        close.setTo(JidCreate.from((String)"juliet@capulet.lit/balcony"));
        close.setStanzaId("us71g45j");
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)close.toXML("jabber:client").toString());
    }
}

