/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b;

import java.net.UnknownHostException;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.provider.JingleS5BTransportProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class JingleS5BTransportTest
extends SmackTestSuite {
    @Test
    public void candidatesProviderTest() throws Exception {
        String xml = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' dstaddr='972b7bf47291ca609517f67f86b5081086052dad' mode='tcp' sid='vj3hs98y'><candidate cid='hft54dqy' host='192.168.4.1' jid='romeo@montague.lit/orchard' port='5086' priority='8257636' type='direct'/><candidate cid='hutr46fe' host='24.24.24.1' jid='romeo@montague.lit/orchard' port='5087' priority='8258636' type='direct'/><candidate cid='xmdh4b7i' host='123.456.7.8' jid='streamer.shakespeare.lit' port='7625' priority='7878787' type='proxy'/></transport>";
        JingleS5BTransport transport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)xml));
        Assertions.assertEquals((Object)"972b7bf47291ca609517f67f86b5081086052dad", (Object)transport.getDestinationAddress());
        Assertions.assertEquals((Object)"vj3hs98y", (Object)transport.getStreamId());
        Assertions.assertEquals((Object)Bytestream.Mode.tcp, (Object)transport.getMode());
        Assertions.assertEquals((int)3, (int)transport.getCandidates().size());
        Assertions.assertTrue((boolean)transport.hasCandidate("hft54dqy"));
        Assertions.assertFalse((boolean)transport.hasCandidate("invalidId"));
        JingleS5BTransportCandidate candidate1 = (JingleS5BTransportCandidate)transport.getCandidates().get(0);
        Assertions.assertEquals((Object)candidate1, (Object)transport.getCandidate("hft54dqy"));
        Assertions.assertNotNull((Object)candidate1.getStreamHost());
        Assertions.assertEquals((int)JingleS5BTransportCandidate.Type.direct.getWeight(), (int)candidate1.getType().getWeight());
        Assertions.assertEquals((Object)"hft54dqy", (Object)candidate1.getCandidateId());
        Assertions.assertEquals((Object)"192.168.4.1", (Object)candidate1.getHost().toString());
        Assertions.assertEquals((Object)JidCreate.from((String)"romeo@montague.lit/orchard"), (Object)candidate1.getJid());
        Assertions.assertEquals((int)5086, (int)candidate1.getPort());
        Assertions.assertEquals((int)8257636, (int)candidate1.getPriority());
        Assertions.assertEquals((Object)JingleS5BTransportCandidate.Type.direct, (Object)candidate1.getType());
        JingleS5BTransportCandidate candidate2 = (JingleS5BTransportCandidate)transport.getCandidates().get(1);
        Assertions.assertEquals((Object)"hutr46fe", (Object)candidate2.getCandidateId());
        Assertions.assertEquals((Object)"24.24.24.1", (Object)candidate2.getHost().toString());
        Assertions.assertEquals((Object)JidCreate.from((String)"romeo@montague.lit/orchard"), (Object)candidate2.getJid());
        Assertions.assertEquals((int)5087, (int)candidate2.getPort());
        Assertions.assertEquals((int)8258636, (int)candidate2.getPriority());
        Assertions.assertEquals((Object)JingleS5BTransportCandidate.Type.direct, (Object)candidate2.getType());
        JingleS5BTransportCandidate candidate3 = (JingleS5BTransportCandidate)transport.getCandidates().get(2);
        Assertions.assertEquals((Object)"xmdh4b7i", (Object)candidate3.getCandidateId());
        Assertions.assertEquals((Object)"123.456.7.8", (Object)candidate3.getHost().toString());
        Assertions.assertEquals((Object)JidCreate.domainBareFrom((String)"streamer.shakespeare.lit"), (Object)candidate3.getJid());
        Assertions.assertEquals((int)7625, (int)candidate3.getPort());
        Assertions.assertEquals((int)0x783883, (int)candidate3.getPriority());
        Assertions.assertEquals((Object)JingleS5BTransportCandidate.Type.proxy, (Object)candidate3.getType());
        Assertions.assertEquals((Object)xml, (Object)transport.toXML().toString());
    }

    @Test
    public void infoProviderTest() throws Exception {
        String candidateError = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><candidate-error/></transport>";
        JingleS5BTransport candidateErrorTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)candidateError));
        Assertions.assertNull((Object)candidateErrorTransport.getDestinationAddress());
        Assertions.assertNotNull((Object)candidateErrorTransport.getInfo());
        Assertions.assertEquals((Object)"vj3hs98y", (Object)candidateErrorTransport.getStreamId());
        Assertions.assertEquals((Object)JingleS5BTransportInfo.CandidateError.INSTANCE, (Object)candidateErrorTransport.getInfo());
        Assertions.assertEquals((Object)candidateError, (Object)candidateErrorTransport.toXML().toString());
        String proxyError = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><proxy-error/></transport>";
        JingleS5BTransport proxyErrorTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)proxyError));
        Assertions.assertNull((Object)proxyErrorTransport.getDestinationAddress());
        Assertions.assertNotNull((Object)proxyErrorTransport.getInfo());
        Assertions.assertNotNull((Object)candidateErrorTransport.getInfo());
        Assertions.assertEquals((Object)"vj3hs98y", (Object)proxyErrorTransport.getStreamId());
        Assertions.assertEquals((Object)JingleS5BTransportInfo.ProxyError.INSTANCE, (Object)proxyErrorTransport.getInfo());
        Assertions.assertEquals((Object)proxyError, (Object)proxyErrorTransport.toXML().toString());
        String candidateUsed = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><candidate-used cid='hr65dqyd'/></transport>";
        JingleS5BTransport candidateUsedTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)candidateUsed));
        Assertions.assertNotNull((Object)candidateUsedTransport.getInfo());
        Assertions.assertEquals((Object)new JingleS5BTransportInfo.CandidateUsed("hr65dqyd"), (Object)candidateUsedTransport.getInfo());
        Assertions.assertEquals((Object)"hr65dqyd", (Object)((JingleS5BTransportInfo.CandidateUsed)candidateUsedTransport.getInfo()).getCandidateId());
        Assertions.assertEquals((Object)candidateUsed, (Object)candidateUsedTransport.toXML().toString());
        String candidateActivated = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><candidate-activated cid='hr65dqyd'/></transport>";
        JingleS5BTransport candidateActivatedTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)candidateActivated));
        Assertions.assertNotNull((Object)candidateActivatedTransport.getInfo());
        Assertions.assertNotNull((Object)candidateErrorTransport.getInfo());
        Assertions.assertEquals((Object)new JingleS5BTransportInfo.CandidateActivated("hr65dqyd"), (Object)candidateActivatedTransport.getInfo());
        Assertions.assertEquals((Object)"hr65dqyd", (Object)((JingleS5BTransportInfo.CandidateActivated)candidateActivatedTransport.getInfo()).getCandidateId());
        Assertions.assertEquals((Object)candidateActivated, (Object)candidateActivatedTransport.toXML().toString());
    }

    @Test
    public void candidateBuilderInvalidPortTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> JingleS5BTransportCandidate.getBuilder().setPort(-5));
    }

    @Test
    public void candidateBuilderInvalidPriorityTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> JingleS5BTransportCandidate.getBuilder().setPriority(-1000));
    }

    @Test
    public void transportCandidateIllegalPriorityTest() throws XmppStringprepException, UnknownHostException {
        FullJid jid = JidCreate.fullFrom((String)"test@test.test/test");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new JingleS5BTransportCandidate("cid", "localhost", (Jid)jid, 5555, -30, JingleS5BTransportCandidate.Type.proxy));
    }

    @Test
    public void transportCandidateIllegalPortTest() throws XmppStringprepException, UnknownHostException {
        FullJid jid = JidCreate.fullFrom((String)"test@test.test/test");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new JingleS5BTransportCandidate("cid", "host", (Jid)jid, -5555, 30, JingleS5BTransportCandidate.Type.proxy));
    }

    @Test
    public void candidateFromStreamHostTest() throws XmppStringprepException, UnknownHostException {
        FullJid jid = JidCreate.fullFrom((String)"test@test.test/test");
        String host = "localhost";
        int port = 1234;
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)jid, host, port);
        JingleS5BTransportCandidate candidate = new JingleS5BTransportCandidate(streamHost, 2000, JingleS5BTransportCandidate.Type.direct);
        Assertions.assertEquals((int)2000, (int)candidate.getPriority());
        Assertions.assertEquals((Object)jid, (Object)candidate.getJid());
        Assertions.assertEquals((Object)host, (Object)candidate.getHost().toString());
        Assertions.assertEquals((int)port, (int)candidate.getPort());
        Assertions.assertEquals((Object)streamHost.toXML().toString(), (Object)candidate.getStreamHost().toXML().toString());
    }

    @Test
    public void typeFromIllegalStringTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> JingleS5BTransportCandidate.Type.fromString((String)"illegal-type"));
    }
}

