/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.provider;

import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrivacyProviderTest
extends SmackTestSuite {
    @Test
    public void parsePrivacyList() throws Exception {
        String xmlPrivacyList = "<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid' value='tybalt@example.com' action='deny' order='1'/><item action='allow' order='2'/></list></query></iq>";
        IQ iqPrivacyList = (IQ)PacketParserUtils.parseStanza((String)"<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid' value='tybalt@example.com' action='deny' order='1'/><item action='allow' order='2'/></list></query></iq>");
        Assertions.assertTrue((boolean)(iqPrivacyList instanceof Privacy));
        Privacy privacyList = (Privacy)iqPrivacyList;
        List pl = privacyList.getPrivacyList("public");
        PrivacyItem first = (PrivacyItem)pl.get(0);
        Assertions.assertEquals((Object)PrivacyItem.Type.jid, (Object)first.getType());
        Assertions.assertEquals((Object)"tybalt@example.com", (Object)first.getValue());
        Assertions.assertEquals((Object)false, (Object)first.isAllow());
        Assertions.assertEquals((long)1L, (long)first.getOrder().nativeRepresentation());
        PrivacyItem second = (PrivacyItem)pl.get(1);
        Assertions.assertEquals((Object)true, (Object)second.isAllow());
        Assertions.assertEquals((long)2L, (long)second.getOrder().nativeRepresentation());
    }

    @Test
    public void parsePrivacyListWithFallThroughInclChildElements() throws Exception {
        String xmlPrivacyList = "<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid' value='tybalt@example.com' action='deny' order='1'/><item action='allow' order='2'><message/><presence-in/></item></list></query></iq>";
        IQ iqPrivacyList = (IQ)PacketParserUtils.parseStanza((String)"<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid' value='tybalt@example.com' action='deny' order='1'/><item action='allow' order='2'><message/><presence-in/></item></list></query></iq>");
        Assertions.assertTrue((boolean)(iqPrivacyList instanceof Privacy));
        Privacy privacyList = (Privacy)iqPrivacyList;
        List pl = privacyList.getPrivacyList("public");
        PrivacyItem first = (PrivacyItem)pl.get(0);
        Assertions.assertEquals((Object)PrivacyItem.Type.jid, (Object)first.getType());
        Assertions.assertEquals((Object)"tybalt@example.com", (Object)first.getValue());
        Assertions.assertEquals((Object)false, (Object)first.isAllow());
        Assertions.assertEquals((long)1L, (long)first.getOrder().nativeRepresentation());
        PrivacyItem second = (PrivacyItem)pl.get(1);
        Assertions.assertTrue((boolean)second.isAllow());
        Assertions.assertEquals((long)2L, (long)second.getOrder().nativeRepresentation());
        Assertions.assertTrue((boolean)second.isFilterMessage());
        Assertions.assertTrue((boolean)second.isFilterPresenceIn());
        Assertions.assertFalse((boolean)second.isFilterPresenceOut());
        Assertions.assertFalse((boolean)second.isFilterIQ());
    }
}

