/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.CharSequenceEquals;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.WaitForPacketListener;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptManager;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.Jid;

public class DeliveryReceiptTest
extends SmackTestSuite {
    private static Properties outputProperties = new Properties();

    @Test
    public void receiptTest() throws Exception {
        String control = XMLBuilder.create((String)"message").a("from", "romeo@montague.com").e("request").a("xmlns", "urn:xmpp:receipts").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Message p = PacketParserUtils.parseMessage((XmlPullParser)parser);
        DeliveryReceiptRequest drr = (DeliveryReceiptRequest)p.getExtension(DeliveryReceiptRequest.class);
        Assertions.assertNotNull((Object)drr);
        Assertions.assertTrue((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Message)p));
        MessageBuilder messageBuilder = ((MessageBuilder)StanzaBuilder.buildMessage((String)"request-id").to((CharSequence)"romeo@montague.com")).ofType(Message.Type.normal);
        Assertions.assertFalse((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Message)messageBuilder.build()));
        DeliveryReceiptRequest.addTo((MessageBuilder)messageBuilder);
        Assertions.assertTrue((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Message)messageBuilder.build()));
    }

    @Test
    public void receiptManagerListenerTest() throws Exception {
        DummyConnection c = new DummyConnection();
        c.connect();
        DeliveryReceiptManager drm = DeliveryReceiptManager.getInstanceFor((XMPPConnection)c);
        TestReceiptReceivedListener rrl = new TestReceiptReceivedListener();
        drm.addReceiptReceivedListener((ReceiptReceivedListener)rrl);
        Message m = ((MessageBuilder)((MessageBuilder)((MessageBuilder)StanzaBuilder.buildMessage((String)"reply-id").from((CharSequence)"julia@capulet.com")).to((CharSequence)"romeo@montague.com")).ofType(Message.Type.normal).addExtension((ExtensionElement)new DeliveryReceipt("original-test-id"))).build();
        c.processStanza((Stanza)m);
        rrl.waitUntilInvocationOrTimeout();
    }

    @Test
    public void receiptManagerAutoReplyTest() throws Exception {
        DummyConnection c = new DummyConnection();
        c.connect();
        DeliveryReceiptManager drm = DeliveryReceiptManager.getInstanceFor((XMPPConnection)c);
        drm.setAutoReceiptMode(DeliveryReceiptManager.AutoReceiptMode.always);
        Assertions.assertEquals((Object)DeliveryReceiptManager.AutoReceiptMode.always, (Object)drm.getAutoReceiptMode());
        MessageBuilder messageBuilder = ((MessageBuilder)((MessageBuilder)StanzaBuilder.buildMessage((String)"test-receipt-request").to((CharSequence)"julia@capulet.com")).from((CharSequence)"romeo@montague.com")).ofType(Message.Type.normal);
        DeliveryReceiptRequest.addTo((MessageBuilder)messageBuilder);
        c.processStanza((Stanza)messageBuilder.build());
        Stanza reply = (Stanza)c.getSentPacket();
        DeliveryReceipt r = DeliveryReceipt.from((Message)((Message)reply));
        MatcherAssert.assertThat((Object)"romeo@montague.com", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)reply.getTo()));
        Assertions.assertEquals((Object)"test-receipt-request", (Object)r.getId());
    }

    static {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    private static class TestReceiptReceivedListener
    extends WaitForPacketListener
    implements ReceiptReceivedListener {
        private TestReceiptReceivedListener() {
        }

        public void onReceiptReceived(Jid fromJid, Jid toJid, String receiptId, Stanza receipt) {
            MatcherAssert.assertThat((Object)"julia@capulet.com", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)fromJid));
            MatcherAssert.assertThat((Object)"romeo@montague.com", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)toJid));
            Assertions.assertEquals((Object)"original-test-id", (Object)receiptId);
            this.reportInvoked();
        }
    }
}

