/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.SingleValueFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FilledForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.util.JidUtil;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppDateTime;

public class FillableForm
extends FilledForm {
    private final Set<String> requiredFields;
    private final Set<String> filledRequiredFields = new HashSet<String>();
    private final Set<String> missingRequiredFields = new HashSet<String>();
    private final Map<String, FormField> filledFields = new HashMap<String, FormField>();

    public FillableForm(DataForm dataForm) {
        super(dataForm);
        if (dataForm.getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        HashSet<String> requiredFields = new HashSet<String>();
        for (FormField formField : dataForm.getFields()) {
            if (!formField.isRequired()) continue;
            String fieldName = formField.getFieldName();
            requiredFields.add(fieldName);
            this.missingRequiredFields.add(fieldName);
        }
        this.requiredFields = Collections.unmodifiableSet(requiredFields);
    }

    protected void writeListMulti(String fieldName, List<? extends CharSequence> values) {
        ListMultiFormField formField = ((ListMultiFormField.Builder)FormField.listMultiBuilder(fieldName).addValues(values)).build();
        this.write(formField);
    }

    protected void writeTextSingle(String fieldName, CharSequence value) {
        TextSingleFormField formField = ((TextSingleFormField.Builder)FormField.textSingleBuilder(fieldName).setValue(value)).build();
        this.write(formField);
    }

    protected void writeBoolean(String fieldName, boolean value) {
        BooleanFormField formField = FormField.booleanBuilder(fieldName).setValue(value).build();
        this.write(formField);
    }

    protected void write(String fieldName, int value) {
        this.writeTextSingle(fieldName, Integer.toString(value));
    }

    protected void write(String fieldName, Date date) {
        this.writeTextSingle(fieldName, XmppDateTime.formatXEP0082Date((Date)date));
    }

    public void setAnswer(String fieldName, Collection<? extends CharSequence> answers) {
        Object filledFormField;
        FormField blankField = this.getFieldOrThrow(fieldName);
        FormField.Type type = blankField.getType();
        switch (type) {
            case list_multi: 
            case text_multi: {
                filledFormField = ((FormField.Builder)FillableForm.createMultiKindFieldbuilder(fieldName, type).addValues(answers)).build();
                break;
            }
            case jid_multi: {
                ArrayList jids = new ArrayList(answers.size());
                ArrayList exceptions = new ArrayList();
                JidUtil.jidsFrom(answers, jids, exceptions);
                if (!exceptions.isEmpty()) {
                    throw new IllegalArgumentException((Throwable)exceptions.get(0));
                }
                filledFormField = FormField.jidMultiBuilder(fieldName).addValues(jids).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        this.write((FormField)filledFormField);
    }

    private static AbstractMultiFormField.Builder<?, ?> createMultiKindFieldbuilder(String fieldName, FormField.Type type) {
        switch (type) {
            case list_multi: {
                return FormField.listMultiBuilder(fieldName);
            }
            case text_multi: {
                return FormField.textMultiBuilder(fieldName);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setAnswer(String fieldName, int answer) {
        this.setAnswer(fieldName, Integer.toString(answer));
    }

    public void setAnswer(String fieldName, CharSequence answer) {
        SingleValueFormField filledFormField;
        FormField blankField = this.getFieldOrThrow(fieldName);
        FormField.Type type = blankField.getType();
        switch (type) {
            case list_multi: 
            case jid_multi: {
                throw new IllegalArgumentException("Can not answer fields of type '" + (Object)((Object)type) + "' with a CharSequence");
            }
            case fixed: {
                throw new IllegalArgumentException("Fields of type 'fixed' are not answerable");
            }
            case list_single: 
            case text_private: 
            case text_single: 
            case hidden: {
                filledFormField = ((FormField.Builder)FillableForm.createSingleKindFieldBuilder(fieldName, type).setValue(answer)).build();
                break;
            }
            case bool: {
                filledFormField = FormField.booleanBuilder(fieldName).setValue(answer).build();
                break;
            }
            case jid_single: {
                Jid jid;
                try {
                    jid = JidCreate.from((CharSequence)answer);
                }
                catch (XmppStringprepException e) {
                    throw new IllegalArgumentException(e);
                }
                filledFormField = FormField.jidSingleBuilder(fieldName).setValue(jid).build();
                break;
            }
            case text_multi: {
                filledFormField = ((FormField.Builder)FillableForm.createMultiKindFieldbuilder(fieldName, type).addValue(answer)).build();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.write(filledFormField);
    }

    private static AbstractSingleStringValueFormField.Builder<?, ?> createSingleKindFieldBuilder(String fieldName, FormField.Type type) {
        switch (type) {
            case text_private: {
                return FormField.textPrivateBuilder(fieldName);
            }
            case text_single: {
                return FormField.textSingleBuilder(fieldName);
            }
            case hidden: {
                return FormField.hiddenBuilder(fieldName);
            }
            case list_single: {
                return FormField.listSingleBuilder(fieldName);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    public void setAnswer(String fieldName, boolean answer) {
        FormField blankField = this.getFieldOrThrow(fieldName);
        if (blankField.getType() != FormField.Type.bool) {
            throw new IllegalArgumentException();
        }
        BooleanFormField filledFormField = FormField.booleanBuilder(fieldName).setValue(answer).build();
        this.write(filledFormField);
    }

    public final void write(FormField filledFormField) {
        if (filledFormField.getType() == FormField.Type.fixed) {
            throw new IllegalArgumentException();
        }
        if (!filledFormField.hasValueSet()) {
            throw new IllegalArgumentException();
        }
        String fieldName = filledFormField.getFieldName();
        if (!this.getDataForm().hasField(fieldName)) {
            throw new IllegalArgumentException();
        }
        if (this.filledFields.containsKey(fieldName)) {
            throw new IllegalArgumentException();
        }
        FormField formFieldPrototype = this.getDataForm().getField(fieldName);
        for (FormFieldChildElement formFieldChildelement : formFieldPrototype.getFormFieldChildElements()) {
            formFieldChildelement.validate(filledFormField);
        }
        this.filledFields.put(fieldName, filledFormField);
        if (this.requiredFields.contains(fieldName)) {
            this.filledRequiredFields.add(fieldName);
            this.missingRequiredFields.remove(fieldName);
        }
    }

    @Override
    public FormField getField(String fieldName) {
        FormField filledField = this.filledFields.get(fieldName);
        if (filledField != null) {
            return filledField;
        }
        return super.getField(fieldName);
    }

    public DataForm getDataFormToSubmit() {
        if (!this.missingRequiredFields.isEmpty()) {
            throw new IllegalStateException("Not all required fields filled. Missing: " + this.missingRequiredFields);
        }
        DataForm.Builder builder = DataForm.builder();
        if (this.formTypeFormField != null) {
            builder.addField(this.formTypeFormField);
        }
        builder.addFields(this.filledFields.values());
        return builder.build();
    }
}

