/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JingleReasonTest
extends SmackTestSuite {
    @Test
    public void parserTest() {
        JingleReasonTest.assertReasonXml("<reason><success/></reason>", JingleReason.Success);
        JingleReasonTest.assertReasonXml("<reason><busy/></reason>", JingleReason.Busy);
        JingleReasonTest.assertReasonXml("<reason><cancel/></reason>", JingleReason.Cancel);
        JingleReasonTest.assertReasonXml("<reason><connectivity-error/></reason>", JingleReason.ConnectivityError);
        JingleReasonTest.assertReasonXml("<reason><decline/></reason>", JingleReason.Decline);
        JingleReasonTest.assertReasonXml("<reason><expired/></reason>", JingleReason.Expired);
        JingleReasonTest.assertReasonXml("<reason><unsupported-transports/></reason>", JingleReason.UnsupportedTransports);
        JingleReasonTest.assertReasonXml("<reason><failed-transport/></reason>", JingleReason.FailedTransport);
        JingleReasonTest.assertReasonXml("<reason><general-error/></reason>", JingleReason.GeneralError);
        JingleReasonTest.assertReasonXml("<reason><gone/></reason>", JingleReason.Gone);
        JingleReasonTest.assertReasonXml("<reason><media-error/></reason>", JingleReason.MediaError);
        JingleReasonTest.assertReasonXml("<reason><security-error/></reason>", JingleReason.SecurityError);
        JingleReasonTest.assertReasonXml("<reason><unsupported-applications/></reason>", JingleReason.UnsupportedApplications);
        JingleReasonTest.assertReasonXml("<reason><timeout/></reason>", JingleReason.Timeout);
        JingleReasonTest.assertReasonXml("<reason><failed-application/></reason>", JingleReason.FailedApplication);
        JingleReasonTest.assertReasonXml("<reason><incompatible-parameters/></reason>", JingleReason.IncompatibleParameters);
        JingleReasonTest.assertReasonXml("<reason><alternative-session><sid>1234</sid></alternative-session></reason>", (JingleReason)JingleReason.AlternativeSession((String)"1234"));
    }

    private static void assertReasonXml(String expected, JingleReason reason) {
        String actualXml = reason.toXML("urn:xmpp:jingle:1").toString();
        Assertions.assertEquals((Object)expected, (Object)actualXml);
    }

    @Test
    public void alternativeSessionEmptyStringTest() {
        Assertions.assertThrows(NullPointerException.class, () -> JingleReason.AlternativeSession((String)""));
    }

    @Test
    public void alternativeSessionNullStringTest() {
        Assertions.assertThrows(NullPointerException.class, () -> JingleReason.AlternativeSession(null));
    }

    @Test
    public void illegalArgumentTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> JingleReason.Reason.fromString((String)"illegal-reason"));
    }
}

