/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.provider;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.bytestreams.ibb.provider.OpenIQProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenIQProviderTest
extends SmackTestSuite {
    private static final Properties outputProperties = new Properties();

    public OpenIQProviderTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test
    public void shouldCorrectlyParseIQStanzaAttribute() throws Exception {
        String control = XMLBuilder.create((String)"open").a("xmlns", "http://jabber.org/protocol/ibb").a("block-size", "4096").a("sid", "i781hf64").a("stanza", "iq").asString(outputProperties);
        OpenIQProvider oip = new OpenIQProvider();
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Open open = (Open)oip.parse(parser);
        Assertions.assertEquals((Object)InBandBytestreamManager.StanzaType.IQ, (Object)open.getStanza());
    }

    @Test
    public void shouldCorrectlyParseMessageStanzaAttribute() throws Exception {
        String control = XMLBuilder.create((String)"open").a("xmlns", "http://jabber.org/protocol/ibb").a("block-size", "4096").a("sid", "i781hf64").a("stanza", "message").asString(outputProperties);
        OpenIQProvider oip = new OpenIQProvider();
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Open open = (Open)oip.parse(parser);
        Assertions.assertEquals((Object)InBandBytestreamManager.StanzaType.MESSAGE, (Object)open.getStanza());
    }
}

