/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class JingleTest
extends SmackTestSuite {
    @Test
    public void emptyBuilderTest() {
        Jingle.Builder builder = Jingle.builder((String)"id");
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.build());
    }

    @Test
    public void onlySessionIdBuilderTest() {
        String sessionId = "testSessionId";
        Jingle.Builder builder = Jingle.builder((String)"id");
        builder.setSessionId(sessionId);
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.build());
    }

    @Test
    public void parserTest() throws XmppStringprepException {
        String sessionId = "testSessionId";
        Jingle.Builder builder = Jingle.builder((String)"id");
        builder.setSessionId(sessionId);
        builder.setAction(JingleAction.session_initiate);
        FullJid romeo = JidCreate.fullFrom((String)"romeo@montague.lit/orchard");
        FullJid juliet = JidCreate.fullFrom((String)"juliet@capulet.lit/balcony");
        builder.setInitiator(romeo);
        builder.setResponder(juliet);
        Jingle jingle = builder.build();
        Assertions.assertNotNull((Object)jingle);
        Assertions.assertEquals((Object)romeo, (Object)jingle.getInitiator());
        Assertions.assertEquals((Object)juliet, (Object)jingle.getResponder());
        Assertions.assertEquals((Object)jingle.getAction(), (Object)JingleAction.session_initiate);
        Assertions.assertEquals((Object)sessionId, (Object)jingle.getSid());
        String xml = "<jingle xmlns='urn:xmpp:jingle:1' initiator='romeo@montague.lit/orchard' responder='juliet@capulet.lit/balcony' action='session-initiate' sid='" + sessionId + "'></jingle>";
        Assertions.assertTrue((boolean)jingle.toXML().toString().contains(xml));
    }
}

