/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.jivesoftware.smackx.jingle.provider.JingleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class JingleProviderTest {
    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testParseUnknownJingleContentDescrption(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String unknownJingleContentDescriptionNamespace = "urn:xmpp:jingle:unknown-description:5";
        String unknownJingleContentDescription = "<description xmlns='urn:xmpp:jingle:unknown-description:5'><file><date>1969-07-21T02:56:15Z</date><desc>This is a test. If this were a real file...</desc><media-type>text/plain</media-type><name>test.txt</name><range/><size>6144</size><hash xmlns='urn:xmpp:hashes:2' algo='sha-1'>w0mcJylzCn+AfvuGdqkty2+KP48=</hash></file></description>";
        CharSequence xml = JingleProviderTest.createTestJingle("<description xmlns='urn:xmpp:jingle:unknown-description:5'><file><date>1969-07-21T02:56:15Z</date><desc>This is a test. If this were a real file...</desc><media-type>text/plain</media-type><name>test.txt</name><range/><size>6144</size><hash xmlns='urn:xmpp:hashes:2' algo='sha-1'>w0mcJylzCn+AfvuGdqkty2+KP48=</hash></file></description>");
        Jingle jingle = (Jingle)SmackTestUtil.parse((CharSequence)xml, JingleProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        JingleContentDescription jingleContentDescription = jingle.getSoleContentOrThrow().getDescription();
        String parsedUnknownJingleContentDescriptionNamespace = jingleContentDescription.getNamespace();
        Assertions.assertEquals((Object)"urn:xmpp:jingle:unknown-description:5", (Object)parsedUnknownJingleContentDescriptionNamespace);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testParseUnknownJingleContentTransport(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String unknownJingleContentTransportNamespace = "urn:xmpp:jingle:unknown-transport:foo:1";
        String unknownJingleContentTransport = "<transport xmlns='urn:xmpp:jingle:unknown-transport:foo:1' mode='tcp' sid='vj3hs98y'><candidate cid='hft54dqy' host='192.168.4.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5086' priority='8257636' type='direct'/><candidate cid='hutr46fe' host='24.24.24.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5087' priority='8258636' type='direct'/></transport>";
        CharSequence xml = JingleProviderTest.createTestJingle("<transport xmlns='urn:xmpp:jingle:unknown-transport:foo:1' mode='tcp' sid='vj3hs98y'><candidate cid='hft54dqy' host='192.168.4.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5086' priority='8257636' type='direct'/><candidate cid='hutr46fe' host='24.24.24.1' jid='romeo@montague.example/dr4hcr0st3lup4c' port='5087' priority='8258636' type='direct'/></transport>");
        Jingle jingle = (Jingle)SmackTestUtil.parse((CharSequence)xml, JingleProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        JingleContentTransport jingleContentTransport = jingle.getSoleContentOrThrow().getTransport();
        String parsedUnknownJingleContentTransportNamespace = jingleContentTransport.getNamespace();
        Assertions.assertEquals((Object)"urn:xmpp:jingle:unknown-transport:foo:1", (Object)parsedUnknownJingleContentTransportNamespace);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testReasonElementWithExtraElement(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xml = "<iq from='juliet@capulet.lit/balcony' id='le71fa63' to='romeo@montague.lit/orchard' type='set'><jingle xmlns='urn:xmpp:jingle:1' action='session-terminate' sid='a73sjjvkla37jfea'><reason><success/><my-element xmlns='https://example.org' foo='bar'/></reason></jingle></iq>";
        Jingle jingle = (Jingle)SmackTestUtil.parse((CharSequence)xml, JingleProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        JingleReason jingleReason = jingle.getReason();
        Assertions.assertEquals((Object)JingleReason.Reason.success, (Object)jingleReason.asEnum());
        ExtensionElement element = jingleReason.getElement();
        Assertions.assertTrue((boolean)(element instanceof StandardExtensionElement));
        StandardExtensionElement extraElement = (StandardExtensionElement)element;
        Assertions.assertEquals((Object)"https://example.org", (Object)extraElement.getNamespace());
        Assertions.assertEquals((Object)"bar", extraElement.getAttributes().get("foo"));
    }

    private static CharSequence createTestJingle(String ... childs) throws XmlPullParserException, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<iq from='romeo@montague.example/dr4hcr0st3lup4c' id='nzu25s8' to='juliet@capulet.example/yn0cl4bnw0yr3vym' type='set'><jingle xmlns='urn:xmpp:jingle:1' action='session-initiate' initiator='romeo@montague.example/dr4hcr0st3lup4c' sid='851ba2'><content creator='initiator' name='a-file-offer' senders='initiator'>");
        for (String child : childs) {
            sb.append(child);
        }
        sb.append("</content></jingle></iq>");
        return sb;
    }
}

