/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smackx.jingle.element.JingleError;
import org.jivesoftware.smackx.jingle.provider.JingleErrorProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JingleErrorTest
extends SmackTestSuite {
    @Test
    public void tieBreakTest() throws Exception {
        String xml = "<tie-break xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        Assertions.assertEquals((Object)xml, (Object)error.toXML().toString());
    }

    @Test
    public void unknownSessionTest() throws Exception {
        String xml = "<unknown-session xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        Assertions.assertEquals((Object)xml, (Object)error.toXML().toString());
    }

    @Test
    public void unsupportedInfoTest() throws Exception {
        String xml = "<unsupported-info xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        Assertions.assertEquals((Object)xml, (Object)error.toXML().toString());
    }

    @Test
    public void outOfOrderTest() throws Exception {
        String xml = "<out-of-order xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        Assertions.assertEquals((Object)xml, (Object)error.toXML().toString());
    }

    @Test
    public void illegalArgumentTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> JingleError.fromString((String)"inexistent-error"));
    }
}

