/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.JidMultiFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

class FormFieldTest {
    FormFieldTest() {
    }

    @Test
    public void testJidMultiToXml() {
        JidMultiFormField jidMultiFormField = FormField.jidMultiBuilder((String)"myfield").addValue((Jid)JidTestUtil.BARE_JID_1).addValue((Jid)JidTestUtil.BARE_JID_2).build();
        String expectedXml = "<field xmlns='jabber:x:data' var='myfield' type='jid-multi'><value>one@exampleone.org</value><value>one@exampletwo.org</value></field>";
        CharSequence xml = jidMultiFormField.toXML();
        XmlAssertUtil.assertXmlSimilar((CharSequence)expectedXml, (CharSequence)xml);
    }

    @Test
    public void testEmptyLabel() {
        TextSingleFormField.Builder builder = FormField.textSingleBuilder((String)"type");
        builder.setLabel("");
        TextSingleFormField formField = builder.build();
        Assertions.assertEquals((Object)"", (Object)formField.getLabel());
    }

    @Test
    public void testThrowExceptionWhenNullLabel() {
        TextSingleFormField.Builder builder = FormField.textSingleBuilder((String)"type");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            TextSingleFormField.Builder cfr_ignored_0 = (TextSingleFormField.Builder)builder.setLabel(null);
        });
    }
}

