/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.Whitebox;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.bytestreams.ibb.IBBPacketUtils;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class InBandBytestreamSessionMessageTest
extends SmackTestSuite {
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final String sessionID = "session_id";
    private static final int blockSize = 10;
    private Protocol protocol;
    private XMPPConnection connection;
    private Open initBytestream;
    private Verification<Message, IQ> incrementingSequence;

    @BeforeEach
    public void setup() throws XMPPException, SmackException, InterruptedException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection((Protocol)this.protocol, (EntityFullJid)initiatorJID);
        this.initBytestream = new Open(sessionID, 10, InBandBytestreamManager.StanzaType.MESSAGE);
        this.initBytestream.setFrom((Jid)initiatorJID);
        this.initBytestream.setTo((Jid)targetJID);
        this.incrementingSequence = new Verification<Message, IQ>(){
            long lastSeq = 0L;

            public void verify(Message request, IQ response) {
                DataPacketExtension dpe = (DataPacketExtension)request.getExtension(DataPacketExtension.class);
                Assertions.assertEquals((long)this.lastSeq++, (long)dpe.getSeq().longValue());
            }
        };
    }

    @Test
    public void shouldSendThreeDataPackets1() throws Exception {
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        byte[] controlData = new byte[30];
        OutputStream outputStream = session.getOutputStream();
        outputStream.write(controlData);
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendThreeDataPackets2() throws Exception {
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        byte[] controlData = new byte[30];
        OutputStream outputStream = session.getOutputStream();
        for (byte b : controlData) {
            outputStream.write(b);
        }
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendThreeDataPackets3() throws Exception {
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        byte[] controlData = new byte[28];
        OutputStream outputStream = session.getOutputStream();
        int off = 0;
        for (int i = 1; i <= 7; ++i) {
            outputStream.write(controlData, off, i);
            off += i;
        }
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendThirtyDataPackets() throws Exception {
        byte[] controlData = new byte[30];
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        for (int i = 0; i < controlData.length; ++i) {
            this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        }
        OutputStream outputStream = session.getOutputStream();
        for (byte b : controlData) {
            outputStream.write(b);
            outputStream.flush();
        }
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendNothingOnSuccessiveCallsToFlush() throws Exception {
        byte[] controlData = new byte[30];
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        this.protocol.addResponse(null, new Verification[]{this.incrementingSequence});
        OutputStream outputStream = session.getOutputStream();
        outputStream.write(controlData);
        outputStream.flush();
        outputStream.flush();
        outputStream.flush();
        this.protocol.verifyAll();
    }

    @Test
    public void shouldSendCloseRequestIfInvalidSequenceReceived() throws Exception {
        IQ resultIQ = IBBPacketUtils.createResultIQ((Jid)initiatorJID, (Jid)targetJID);
        this.protocol.addResponse((Stanza)resultIQ, new Verification[]{Verification.requestTypeSET, Verification.correspondingSenderReceiver});
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        String base64Data = Base64.encode((String)"Data");
        DataPacketExtension dpe = new DataPacketExtension(sessionID, 123, base64Data);
        Message dataMessage = ((MessageBuilder)StanzaBuilder.buildMessage().addExtension((ExtensionElement)dpe)).build();
        listener.processStanza((Stanza)dataMessage);
        IOException ioException = (IOException)Assertions.assertThrows(IOException.class, () -> inputStream.read());
        String ioExceptionMessage = ioException.getMessage();
        Assertions.assertTrue((boolean)ioExceptionMessage.startsWith("Unexpected IBB sequence"));
        this.protocol.verifyAll();
    }

    @Test
    public void shouldReadAllReceivedData1() throws Exception {
        Random rand = new Random();
        byte[] controlData = new byte[30];
        rand.nextBytes(controlData);
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        for (int i = 0; i < controlData.length / 10; ++i) {
            String base64Data = Base64.encodeToString((byte[])controlData, (int)(i * 10), (int)10);
            DataPacketExtension dpe = new DataPacketExtension(sessionID, i, base64Data);
            Message dataMessage = ((MessageBuilder)StanzaBuilder.buildMessage().addExtension((ExtensionElement)dpe)).build();
            listener.processStanza((Stanza)dataMessage);
        }
        byte[] bytes = new byte[30];
        int read = inputStream.read(bytes, 0, 10);
        Assertions.assertEquals((int)10, (int)read);
        read = inputStream.read(bytes, 10, 10);
        Assertions.assertEquals((int)10, (int)read);
        read = inputStream.read(bytes, 20, 10);
        Assertions.assertEquals((int)10, (int)read);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)controlData[i], (byte)bytes[i]);
        }
        this.protocol.verifyAll();
    }

    @Test
    public void shouldReadAllReceivedData2() throws Exception {
        int i;
        Random rand = new Random();
        byte[] controlData = new byte[30];
        rand.nextBytes(controlData);
        InBandBytestreamSession session = new InBandBytestreamSession(this.connection, this.initBytestream, (Jid)initiatorJID);
        InputStream inputStream = session.getInputStream();
        StanzaListener listener = (StanzaListener)Whitebox.getInternalState((Object)inputStream, (String)"dataPacketListener", StanzaListener.class);
        for (int i2 = 0; i2 < controlData.length / 10; ++i2) {
            String base64Data = Base64.encodeToString((byte[])controlData, (int)(i2 * 10), (int)10);
            DataPacketExtension dpe = new DataPacketExtension(sessionID, i2, base64Data);
            Message dataMessage = ((MessageBuilder)StanzaBuilder.buildMessage().addExtension((ExtensionElement)dpe)).build();
            listener.processStanza((Stanza)dataMessage);
        }
        byte[] bytes = new byte[30];
        for (i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)inputStream.read();
        }
        for (i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)controlData[i], (byte)bytes[i]);
        }
        this.protocol.verifyAll();
    }
}

