/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.test.util.NetworkUtil;
import org.jivesoftware.smack.util.ExceptionUtil;
import org.jivesoftware.smackx.bytestreams.ibb.IBBPacketUtils;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5PacketUtils;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5TestProxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.mockito.Mockito;

public class Socks5ByteStreamManagerTest {
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final DomainBareJid xmppServer = initiatorJID.asDomainBareJid();
    private static final DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    private static final String proxyAddress = "127.0.0.1";

    @Test
    public void shouldHaveOneManagerForEveryConnection() {
        XMPPConnection connection1 = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        XMPPConnection connection2 = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection1);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection2);
        Socks5BytestreamManager conn1ByteStreamManager1 = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection1);
        Socks5BytestreamManager conn1ByteStreamManager2 = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection1);
        Socks5BytestreamManager conn2ByteStreamManager1 = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection2);
        Assertions.assertEquals((Object)conn1ByteStreamManager1, (Object)conn1ByteStreamManager2);
        Assertions.assertNotSame((Object)conn1ByteStreamManager1, (Object)conn2ByteStreamManager1);
    }

    @Test
    public void shouldDisableService() throws XMPPException.XMPPErrorException, SmackException, InterruptedException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        Assertions.assertTrue((boolean)discoveryManager.includesFeature("http://jabber.org/protocol/bytestreams"));
        byteStreamManager.disableService();
        Assertions.assertFalse((boolean)discoveryManager.includesFeature("http://jabber.org/protocol/bytestreams"));
    }

    @Test
    public void shouldFailIfTargetDoesNotSupportSocks5() throws XMPPException, SmackException, InterruptedException, IOException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        SmackException.FeatureNotSupportedException e = (SmackException.FeatureNotSupportedException)Assertions.assertThrows(SmackException.FeatureNotSupportedException.class, () -> {
            DiscoverInfo discoverInfo = DiscoverInfo.builder((String)"disco-1").build();
            protocol.addResponse((Stanza)discoverInfo, new Verification[0]);
            byteStreamManager.establishSession((Jid)targetJID);
        });
        Assertions.assertTrue((boolean)e.getFeature().equals("SOCKS5 Bytestream"));
        Assertions.assertTrue((boolean)e.getJid().equals((CharSequence)targetJID));
    }

    @Test
    public void shouldFailIfNoSocks5ProxyFound1() throws SmackException, InterruptedException, IOException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldFailIfNoSocks5ProxyFound1";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        DiscoverInfoBuilder discoverInfo = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        protocol.addResponse((Stanza)discoverInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        SmackException e = (SmackException)Assertions.assertThrows(SmackException.class, () -> {
            byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldFailIfNoSocks5ProxyFound1");
            Assertions.fail((String)"exception should be thrown");
        });
        protocol.verifyAll();
        Assertions.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
    }

    @Test
    public void shouldFailIfNoSocks5ProxyFound2() throws SmackException, InterruptedException, IOException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldFailIfNoSocks5ProxyFound2";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        DiscoverInfoBuilder discoverInfo = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        protocol.addResponse((Stanza)discoverInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item((Jid)proxyJID);
        discoverItems.addItem(item);
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo = Socks5PacketUtils.createDiscoverInfo((Jid)proxyJID, (Jid)initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("noproxy", proxyJID.toString(), "bytestreams");
        proxyInfo.addIdentity(identity);
        protocol.addResponse((Stanza)proxyInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        SmackException e = (SmackException)Assertions.assertThrows(SmackException.class, () -> byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldFailIfNoSocks5ProxyFound2"));
        protocol.verifyAll();
        Assertions.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
    }

    @Test
    public void shouldBlacklistNonSocks5Proxies() throws SmackException, InterruptedException, IOException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldBlacklistNonSocks5Proxies";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        DiscoverInfoBuilder discoverInfoBuilder = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfoBuilder.addFeature("http://jabber.org/protocol/bytestreams");
        DiscoverInfo discoverInfo = discoverInfoBuilder.build();
        protocol.addResponse((Stanza)discoverInfo, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item((Jid)proxyJID);
        discoverItems.addItem(item);
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo = Socks5PacketUtils.createDiscoverInfo((Jid)proxyJID, (Jid)initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("noproxy", proxyJID.toString(), "bytestreams");
        proxyInfo.addIdentity(identity);
        protocol.addResponse((Stanza)proxyInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        SmackException e = (SmackException)Assertions.assertThrows(SmackException.class, () -> {
            byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldBlacklistNonSocks5Proxies");
            Assertions.fail((String)"exception should be thrown");
        });
        protocol.verifyAll();
        Assertions.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
        protocol.addResponse((Stanza)discoverInfo, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        e = (SmackException)Assertions.assertThrows(SmackException.class, () -> byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldBlacklistNonSocks5Proxies"));
        protocol.verifyAll();
        Assertions.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
    }

    @Test
    public void shouldFailIfTargetDoesNotAcceptSocks5Bytestream() throws SmackException, InterruptedException, IOException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldFailIfTargetDoesNotAcceptSocks5Bytestream";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        DiscoverInfoBuilder discoverInfo = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        protocol.addResponse((Stanza)discoverInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item((Jid)proxyJID);
        discoverItems.addItem(item);
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo = Socks5PacketUtils.createDiscoverInfo((Jid)proxyJID, (Jid)initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", proxyJID.toString(), "bytestreams");
        proxyInfo.addIdentity(identity);
        protocol.addResponse((Stanza)proxyInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse((Jid)proxyJID, (Jid)initiatorJID);
        streamHostInfo.addStreamHost((Jid)proxyJID, proxyAddress, 7778);
        protocol.addResponse((Stanza)streamHostInfo, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        IQ rejectPacket = IBBPacketUtils.createErrorIQ((Jid)targetJID, (Jid)initiatorJID, StanzaError.Condition.not_acceptable);
        protocol.addResponse((Stanza)rejectPacket, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeSET});
        XMPPException.XMPPErrorException e = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldFailIfTargetDoesNotAcceptSocks5Bytestream"));
        protocol.verifyAll();
        Assertions.assertEquals((Object)rejectPacket.getError(), (Object)e.getStanzaError());
    }

    @Test
    public void shouldFailIfTargetUsesInvalidSocks5Proxy() throws SmackException, InterruptedException, IOException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldFailIfTargetUsesInvalidSocks5Proxy";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        DiscoverInfoBuilder discoverInfo = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        protocol.addResponse((Stanza)discoverInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item((Jid)proxyJID);
        discoverItems.addItem(item);
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo = Socks5PacketUtils.createDiscoverInfo((Jid)proxyJID, (Jid)initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", proxyJID.toString(), "bytestreams");
        proxyInfo.addIdentity(identity);
        protocol.addResponse((Stanza)proxyInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse((Jid)proxyJID, (Jid)initiatorJID);
        streamHostInfo.addStreamHost((Jid)proxyJID, proxyAddress, 7778);
        protocol.addResponse((Stanza)streamHostInfo, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse((Jid)targetJID, (Jid)initiatorJID);
        streamHostUsedPacket.setSessionID("session_id_shouldFailIfTargetUsesInvalidSocks5Proxy");
        streamHostUsedPacket.setUsedHost(JidCreate.from((String)"invalid.proxy"));
        protocol.addResponse((Stanza)streamHostUsedPacket, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeSET});
        SmackException e = (SmackException)Assertions.assertThrows(SmackException.class, () -> byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldFailIfTargetUsesInvalidSocks5Proxy"));
        protocol.verifyAll();
        Assertions.assertTrue((boolean)e.getMessage().contains("Remote user responded with unknown host"));
    }

    @Test
    public void shouldFailIfInitiatorCannotConnectToSocks5Proxy() throws SmackException, InterruptedException, XMPPException, XmppStringprepException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldFailIfInitiatorCannotConnectToSocks5Proxy";
        DomainBareJid proxyJID = JidCreate.domainBareFrom((String)"s5b-proxy.initiator.org");
        String proxyAddress = "192.0.2.1";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        byteStreamManager.setProxyConnectionTimeout(3000);
        DiscoverInfoBuilder discoverInfoBuilder = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfoBuilder.addFeature("http://jabber.org/protocol/bytestreams");
        protocol.addResponse((Stanza)discoverInfoBuilder.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item((Jid)proxyJID);
        discoverItems.addItem(item);
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo = Socks5PacketUtils.createDiscoverInfo((Jid)proxyJID, (Jid)initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", proxyJID.toString(), "bytestreams");
        proxyInfo.addIdentity(identity);
        protocol.addResponse((Stanza)proxyInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse((Jid)proxyJID, (Jid)initiatorJID);
        streamHostInfo.addStreamHost((Jid)proxyJID, "192.0.2.1", 7778);
        protocol.addResponse((Stanza)streamHostInfo, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse((Jid)targetJID, (Jid)initiatorJID);
        streamHostUsedPacket.setSessionID("session_id_shouldFailIfInitiatorCannotConnectToSocks5Proxy");
        streamHostUsedPacket.setUsedHost((Jid)proxyJID);
        protocol.addResponse((Stanza)streamHostUsedPacket, new Verification[]{new Verification<Bytestream, Bytestream>(){

            public void verify(Bytestream request, Bytestream response) {
                Assertions.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assertions.assertEquals((int)1, (int)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[0];
                Assertions.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET});
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldFailIfInitiatorCannotConnectToSocks5Proxy"));
        protocol.verifyAll();
        Throwable actualCause = e.getCause();
        Assertions.assertEquals(TimeoutException.class, actualCause.getClass(), (String)("Unexpected throwable: " + actualCause + '.' + ExceptionUtil.getStackTrace((Throwable)actualCause)));
    }

    @Test
    public void shouldNegotiateSocks5BytestreamAndTransferData() throws SmackException, InterruptedException, IOException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldNegotiateSocks5BytestreamAndTransferData";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        DiscoverInfoBuilder discoverInfo = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        protocol.addResponse((Stanza)discoverInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item((Jid)proxyJID);
        discoverItems.addItem(item);
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo = Socks5PacketUtils.createDiscoverInfo((Jid)proxyJID, (Jid)initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", proxyJID.toString(), "bytestreams");
        proxyInfo.addIdentity(identity);
        protocol.addResponse((Stanza)proxyInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        ServerSocket proxyServerSocket = NetworkUtil.getSocketOnLoopback();
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse((Jid)proxyJID, (Jid)initiatorJID);
        streamHostInfo.addStreamHost((Jid)proxyJID, proxyAddress, proxyServerSocket.getLocalPort());
        protocol.addResponse((Stanza)streamHostInfo, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse((Jid)targetJID, (Jid)initiatorJID);
        streamHostUsedPacket.setSessionID("session_id_shouldNegotiateSocks5BytestreamAndTransferData");
        streamHostUsedPacket.setUsedHost((Jid)proxyJID);
        protocol.addResponse((Stanza)streamHostUsedPacket, new Verification[]{new Verification<Bytestream, Bytestream>(){

            public void verify(Bytestream request, Bytestream response) {
                Assertions.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assertions.assertEquals((int)1, (int)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[0];
                Assertions.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET});
        IQ activationResponse = Socks5PacketUtils.createActivationConfirmation((Jid)proxyJID, (Jid)initiatorJID);
        protocol.addResponse((Stanza)activationResponse, new Verification[]{new Verification<Bytestream, IQ>(){

            public void verify(Bytestream request, IQ response) {
                Assertions.assertEquals((Object)targetJID, (Object)request.getToActivate().getTarget());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET});
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy(proxyServerSocket);){
            String digest = Socks5Utils.createDigest((String)"session_id_shouldNegotiateSocks5BytestreamAndTransferData", (Jid)initiatorJID, (Jid)targetJID);
            OutputStream outputStream = byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldNegotiateSocks5BytestreamAndTransferData").getOutputStream();
            InputStream inputStream = socks5Proxy.getSocket(digest).getInputStream();
            byte[] data = new byte[]{1, 2, 3};
            outputStream.write(data);
            byte[] result = new byte[3];
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
        }
        protocol.verifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseMultipleAddressesForLocalSocks5Proxy() throws SmackException, InterruptedException, IOException, TimeoutException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldUseMultipleAddressesForLocalSocks5Proxy";
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.start();
        try {
            Assertions.assertTrue((boolean)socks5Proxy.isRunning());
            Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
            DiscoverInfoBuilder discoverInfo = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
            discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
            protocol.addResponse((Stanza)discoverInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
            DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
            protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
            Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse((Jid)targetJID, (Jid)initiatorJID);
            streamHostUsedPacket.setSessionID("session_id_shouldUseMultipleAddressesForLocalSocks5Proxy");
            streamHostUsedPacket.setUsedHost((Jid)initiatorJID);
            String secondStreamHostIp = "192.0.0.1";
            protocol.addResponse((Stanza)streamHostUsedPacket, new Verification[]{new Verification<Bytestream, Bytestream>(){

                public void verify(Bytestream request, Bytestream response) {
                    Assertions.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                    List streamHosts = request.getStreamHosts();
                    Bytestream.StreamHost streamHost1 = (Bytestream.StreamHost)streamHosts.get(0);
                    Assertions.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost1.getJID());
                    Bytestream.StreamHost streamHost2 = (Bytestream.StreamHost)streamHosts.get(streamHosts.size() - 1);
                    Assertions.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost2.getJID());
                    Assertions.assertEquals((Object)"192.0.0.1", (Object)streamHost2.getAddress().toString());
                }
            }, Verification.correspondingSenderReceiver, Verification.requestTypeSET});
            String digest = Socks5Utils.createDigest((String)"session_id_shouldUseMultipleAddressesForLocalSocks5Proxy", (Jid)initiatorJID, (Jid)targetJID);
            socks5Proxy.addTransfer(digest);
            Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)targetJID, (InetAddress)socks5Proxy.getLocalAddresses().get(0), socks5Proxy.getPort());
            Socks5Client socks5Client = new Socks5Client(streamHost, digest);
            InputStream inputStream = socks5Client.getSocket(10000).getInputStream();
            socks5Proxy.addLocalAddress(InetAddress.getByName("192.0.0.1"));
            OutputStream outputStream = byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldUseMultipleAddressesForLocalSocks5Proxy").getOutputStream();
            byte[] data = new byte[]{1, 2, 3};
            outputStream.write(data);
            byte[] result = new byte[3];
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
            protocol.verifyAll();
        }
        finally {
            socks5Proxy.stop();
        }
    }

    @Test
    public void shouldPrioritizeSecondSocks5ProxyOnSecondAttempt() throws SmackException, InterruptedException, IOException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldPrioritizeSecondSocks5ProxyOnSecondAttempt";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        Assertions.assertTrue((boolean)byteStreamManager.isProxyPrioritizationEnabled());
        Verification<Bytestream, Bytestream> streamHostUsedVerification1 = new Verification<Bytestream, Bytestream>(){

            public void verify(Bytestream request, Bytestream response) {
                Assertions.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assertions.assertEquals((int)2, (int)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[1];
                Assertions.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        };
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy();){
            Socks5ByteStreamManagerTest.createResponses(protocol, "session_id_shouldPrioritizeSecondSocks5ProxyOnSecondAttempt", streamHostUsedVerification1, socks5Proxy);
            String digest = Socks5Utils.createDigest((String)"session_id_shouldPrioritizeSecondSocks5ProxyOnSecondAttempt", (Jid)initiatorJID, (Jid)targetJID);
            OutputStream outputStream = byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldPrioritizeSecondSocks5ProxyOnSecondAttempt").getOutputStream();
            InputStream inputStream = socks5Proxy.getSocket(digest).getInputStream();
            byte[] data = new byte[]{1, 2, 3};
            outputStream.write(data);
            byte[] result = new byte[3];
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
            protocol.verifyAll();
            Verification<Bytestream, Bytestream> streamHostUsedVerification2 = new Verification<Bytestream, Bytestream>(){

                public void verify(Bytestream request, Bytestream response) {
                    Assertions.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                    Assertions.assertEquals((int)2, (int)request.getStreamHosts().size());
                    Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[0];
                    Assertions.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
                }
            };
            Socks5ByteStreamManagerTest.createResponses(protocol, "session_id_shouldPrioritizeSecondSocks5ProxyOnSecondAttempt", streamHostUsedVerification2, socks5Proxy);
            outputStream = byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldPrioritizeSecondSocks5ProxyOnSecondAttempt").getOutputStream();
            inputStream = socks5Proxy.getSocket(digest).getInputStream();
            outputStream.write(data);
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
            protocol.verifyAll();
        }
    }

    @Test
    public void shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled() throws IOException, SmackException, InterruptedException, XMPPException {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)initiatorJID);
        String sessionID = "session_id_shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled";
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        byteStreamManager.setAnnounceLocalStreamHost(false);
        byteStreamManager.setProxyPrioritizationEnabled(false);
        Assertions.assertFalse((boolean)byteStreamManager.isProxyPrioritizationEnabled());
        Verification<Bytestream, Bytestream> streamHostUsedVerification = new Verification<Bytestream, Bytestream>(){

            public void verify(Bytestream request, Bytestream response) {
                Assertions.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assertions.assertEquals((int)2, (int)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[1];
                Assertions.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        };
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy();){
            Socks5ByteStreamManagerTest.createResponses(protocol, "session_id_shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled", streamHostUsedVerification, socks5Proxy);
            String digest = Socks5Utils.createDigest((String)"session_id_shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled", (Jid)initiatorJID, (Jid)targetJID);
            OutputStream outputStream = byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled").getOutputStream();
            InputStream inputStream = socks5Proxy.getSocket(digest).getInputStream();
            byte[] data = new byte[]{1, 2, 3};
            outputStream.write(data);
            byte[] result = new byte[3];
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
            protocol.verifyAll();
            Socks5ByteStreamManagerTest.createResponses(protocol, "session_id_shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled", streamHostUsedVerification, socks5Proxy);
            outputStream = byteStreamManager.establishSession((Jid)targetJID, "session_id_shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled").getOutputStream();
            inputStream = socks5Proxy.getSocket(digest).getInputStream();
            outputStream.write(data);
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
        }
        protocol.verifyAll();
    }

    private static void createResponses(Protocol protocol, String sessionID, Verification<Bytestream, Bytestream> streamHostUsedVerification, Socks5TestProxy socks5TestProxy) throws XmppStringprepException {
        DiscoverInfoBuilder discoverInfo = Socks5PacketUtils.createDiscoverInfo((Jid)targetJID, (Jid)initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        protocol.addResponse((Stanza)discoverInfo.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems((Jid)xmppServer, (Jid)initiatorJID);
        discoverItems.addItem(new DiscoverItems.Item(JidCreate.from((String)"proxy2.xmpp-server")));
        discoverItems.addItem(new DiscoverItems.Item((Jid)proxyJID));
        protocol.addResponse((Stanza)discoverItems, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo1 = Socks5PacketUtils.createDiscoverInfo(JidCreate.from((String)"proxy2.xmpp-server"), (Jid)initiatorJID);
        DiscoverInfo.Identity identity1 = new DiscoverInfo.Identity("proxy", "proxy2.xmpp-server", "bytestreams");
        proxyInfo1.addIdentity(identity1);
        protocol.addResponse((Stanza)proxyInfo1.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        DiscoverInfoBuilder proxyInfo2 = Socks5PacketUtils.createDiscoverInfo((Jid)proxyJID, (Jid)initiatorJID);
        DiscoverInfo.Identity identity2 = new DiscoverInfo.Identity("proxy", proxyJID.toString(), "bytestreams");
        proxyInfo2.addIdentity(identity2);
        protocol.addResponse((Stanza)proxyInfo2.build(), new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostInfo1 = Socks5PacketUtils.createBytestreamResponse(JidCreate.from((String)"proxy2.xmpp-server"), (Jid)initiatorJID);
        streamHostInfo1.addStreamHost(JidCreate.from((String)"proxy2.xmpp-server"), proxyAddress, socks5TestProxy.getPort());
        protocol.addResponse((Stanza)streamHostInfo1, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostInfo2 = Socks5PacketUtils.createBytestreamResponse((Jid)proxyJID, (Jid)initiatorJID);
        streamHostInfo2.addStreamHost((Jid)proxyJID, proxyAddress, socks5TestProxy.getPort());
        protocol.addResponse((Stanza)streamHostInfo2, new Verification[]{Verification.correspondingSenderReceiver, Verification.requestTypeGET});
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse((Jid)targetJID, (Jid)initiatorJID);
        streamHostUsedPacket.setSessionID(sessionID);
        streamHostUsedPacket.setUsedHost((Jid)proxyJID);
        protocol.addResponse((Stanza)streamHostUsedPacket, new Verification[]{streamHostUsedVerification, Verification.correspondingSenderReceiver, Verification.requestTypeSET});
        IQ activationResponse = Socks5PacketUtils.createActivationConfirmation((Jid)proxyJID, (Jid)initiatorJID);
        protocol.addResponse((Stanza)activationResponse, new Verification[]{new Verification<Bytestream, IQ>(){

            public void verify(Bytestream request, IQ response) {
                Assertions.assertEquals((Object)targetJID, (Object)request.getToActivate().getTarget());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET});
    }
}

