/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.test.util.NetworkUtil;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class Socks5ClientTest {
    private int serverPort;
    private String serverAddress;
    private DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    private String digest = "digest";
    private ServerSocket serverSocket;

    @BeforeEach
    public void setup() throws Exception {
        this.serverSocket = NetworkUtil.getSocketOnLoopback();
        this.serverAddress = this.serverSocket.getInetAddress().getHostAddress();
        this.serverPort = this.serverSocket.getLocalPort();
    }

    @Test
    public void shouldCloseSocketIfServerDoesNotAcceptAuthenticationMethod() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    socks5Client.getSocket(10000);
                    Assertions.fail((String)"exception should be thrown");
                }
                catch (SmackException e) {
                    Assertions.assertTrue((boolean)e.getMessage().contains("SOCKS5 negotiation failed"));
                }
                catch (Exception e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assertions.assertEquals((byte)5, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)1, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)0, (byte)((byte)in.read()));
        out.write(new byte[]{5, -1});
        out.flush();
        serverThread.join();
        Assertions.assertEquals((int)-1, (int)in.read());
    }

    @Test
    public void shouldCloseSocketIfServerRepliesInUnsupportedWay() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    socks5Client.getSocket(10000);
                    Assertions.fail((String)"exception should be thrown");
                }
                catch (SmackException e) {
                    Assertions.assertTrue((boolean)e.getMessage().contains("Unsupported SOCKS5 address type"));
                }
                catch (Exception e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assertions.assertEquals((byte)5, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)1, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)0, (byte)((byte)in.read()));
        out.write(new byte[]{5, 0});
        out.flush();
        Socks5Utils.receiveSocks5Message((DataInputStream)in);
        out.write(new byte[]{5, 0, 0, 1, 0});
        out.flush();
        serverThread.join();
        Assertions.assertEquals((int)-1, (int)in.read());
    }

    @Test
    public void shouldCloseSocketIfServerRepliesWithError() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    socks5Client.getSocket(10000);
                    Assertions.fail((String)"exception should be thrown");
                }
                catch (SmackException e) {
                    Assertions.assertTrue((boolean)e.getMessage().contains("SOCKS5 negotiation failed"));
                }
                catch (Exception e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assertions.assertEquals((byte)5, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)1, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)0, (byte)((byte)in.read()));
        out.write(new byte[]{5, 0});
        out.flush();
        Socks5Utils.receiveSocks5Message((DataInputStream)in);
        out.write(new byte[]{5, 1, 0, 3});
        byte[] address = this.digest.getBytes(StandardCharsets.UTF_8);
        out.write(address.length);
        out.write(address);
        out.write(new byte[]{0, 0});
        out.flush();
        serverThread.join();
        Assertions.assertEquals((int)-1, (int)in.read());
    }

    @Test
    public void shouldSuccessfullyConnectToSocks5Server() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    Socket socket = socks5Client.getSocket(10000);
                    Assertions.assertNotNull((Object)socket);
                    socket.getOutputStream().write(123);
                    socket.close();
                }
                catch (Exception e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assertions.assertEquals((byte)5, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)1, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)0, (byte)((byte)in.read()));
        out.write(new byte[]{5, 0});
        out.flush();
        byte[] address = this.digest.getBytes(StandardCharsets.UTF_8);
        Assertions.assertEquals((byte)5, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)1, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)0, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)3, (byte)((byte)in.read()));
        Assertions.assertEquals((int)address.length, (int)((byte)in.read()));
        for (int i = 0; i < address.length; ++i) {
            Assertions.assertEquals((byte)address[i], (byte)((byte)in.read()));
        }
        Assertions.assertEquals((byte)0, (byte)((byte)in.read()));
        Assertions.assertEquals((byte)0, (byte)((byte)in.read()));
        out.write(new byte[]{5, 0, 0, 3});
        out.write(address.length);
        out.write(address);
        out.write(new byte[]{0, 0});
        out.flush();
        serverThread.join();
        Assertions.assertEquals((int)123, (int)in.read());
        Assertions.assertEquals((int)-1, (int)in.read());
    }

    @AfterEach
    public void cleanup() throws Exception {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }
}

