/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.nick;

import java.io.IOException;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.nick.packet.Nick;
import org.jivesoftware.smackx.nick.provider.NickProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class NickTest {
    private static final String XML = "<nick xmlns='http://jabber.org/protocol/nick'>Ishmael</nick>";

    @Test
    public void disallowEmptyNickTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Nick(""), (String)"Empty String as argument MUST cause IllegalArgumentException.");
    }

    @Test
    public void disallowNullNickTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Nick(null), (String)"Null argument MUST cause IllegalArgumentException.");
    }

    @Test
    public void serializationTest() {
        Nick nick = new Nick("Ishmael");
        XmlAssertUtil.assertXmlSimilar((CharSequence)XML, (CharSequence)nick.toXML());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void deserializationTest(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        Nick nick = (Nick)SmackTestUtil.parse((CharSequence)XML, NickProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        Assertions.assertNotNull((Object)nick);
        Assertions.assertEquals((Object)"Ishmael", (Object)nick.getName());
    }

    @Test
    public void nicksAreEscapedTest() {
        String name = "</nick>\"'&";
        Nick nick = new Nick(name);
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<nick xmlns='http://jabber.org/protocol/nick'>&lt;/nick&gt;&quot;&apos;&amp;</nick>", (CharSequence)nick.toXML());
        Assertions.assertEquals((Object)name, (Object)nick.getName());
    }
}

