/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.provider;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.time.packet.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeProviderTest {
    @Test
    public void parseTimeWithIntrospectionTest() throws Exception {
        String request = "<iq type='get' from='romeo@montague.net/orchard' to='juliet@capulet.com/balcony' id='time_1'><time xmlns='urn:xmpp:time'/></iq>";
        IQ iqRequest = (IQ)PacketParserUtils.parseStanza((String)"<iq type='get' from='romeo@montague.net/orchard' to='juliet@capulet.com/balcony' id='time_1'><time xmlns='urn:xmpp:time'/></iq>");
        Assertions.assertTrue((boolean)(iqRequest instanceof Time));
        String response = "<iq type='result' from='juliet@capulet.com/balcony' to='romeo@montague.net/orchard' id='time_1'><time xmlns='urn:xmpp:time'><tzo>-06:00</tzo><utc>2006-12-19T17:58:35Z</utc></time></iq>";
        IQ iqResponse = (IQ)PacketParserUtils.parseStanza((String)"<iq type='result' from='juliet@capulet.com/balcony' to='romeo@montague.net/orchard' id='time_1'><time xmlns='urn:xmpp:time'><tzo>-06:00</tzo><utc>2006-12-19T17:58:35Z</utc></time></iq>");
        Assertions.assertTrue((boolean)(iqResponse instanceof Time));
        Time time = (Time)iqResponse;
        Assertions.assertEquals((Object)"-06:00", (Object)time.getTzo());
        Assertions.assertEquals((Object)"2006-12-19T17:58:35Z", (Object)time.getUtc());
    }
}

