/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JivePropertiesExtensionTest
extends SmackTestSuite {
    @BeforeEach
    public void setUp() {
        JivePropertiesManager.setJavaObjectEnabled((boolean)true);
    }

    @AfterEach
    public void tearDown() {
        JivePropertiesManager.setJavaObjectEnabled((boolean)false);
    }

    @Test
    public void checkProvider() throws Exception {
        String properties = "<message xmlns='jabber:client' from='romeo@example.net/orchard' to='juliet@example.com/balcony'><body>Neither, fair saint, if either thee dislike.</body><properties xmlns='http://www.jivesoftware.com/xmlns/xmpp/properties'><property><name>FooBar</name><value type='integer'>42</value></property></properties></message>";
        Message message = (Message)PacketParserUtils.parseStanza((String)properties);
        JivePropertiesExtension jpe = JivePropertiesExtension.from((Message)message);
        Assertions.assertNotNull((Object)jpe);
        Integer integer = (Integer)jpe.getProperty("FooBar");
        Assertions.assertNotNull((Object)integer);
        int fourtytwo = integer;
        Assertions.assertEquals((int)42, (int)fourtytwo);
    }
}

