/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jxmpp.jid.Jid;

public class BytestreamsProvider
extends IQProvider<Bytestream> {
    public Bytestream parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        boolean done = false;
        Bytestream toReturn = new Bytestream();
        String id = parser.getAttributeValue("", "sid");
        String mode = parser.getAttributeValue("", "mode");
        Jid JID = null;
        String host = null;
        String port = null;
        while (!done) {
            String elementName;
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                elementName = parser.getName();
                if (elementName.equals("streamhost")) {
                    JID = ParserUtils.getJidAttribute((XmlPullParser)parser);
                    host = parser.getAttributeValue("", "host");
                    port = parser.getAttributeValue("", "port");
                    continue;
                }
                if (elementName.equals("streamhost-used")) {
                    toReturn.setUsedHost(ParserUtils.getJidAttribute((XmlPullParser)parser));
                    continue;
                }
                if (!elementName.equals("activate")) continue;
                toReturn.setToActivate(ParserUtils.getJidAttribute((XmlPullParser)parser));
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT) continue;
            elementName = parser.getName();
            if (elementName.equals("streamhost")) {
                if (port == null) {
                    toReturn.addStreamHost(JID, host);
                } else {
                    toReturn.addStreamHost(JID, host, Integer.parseInt(port));
                }
                JID = null;
                host = null;
                port = null;
                continue;
            }
            if (!elementName.equals("query")) continue;
            done = true;
        }
        if (mode == null) {
            toReturn.setMode(Bytestream.Mode.tcp);
        } else {
            toReturn.setMode(Bytestream.Mode.fromName(mode));
        }
        toReturn.setSessionID(id);
        return toReturn;
    }
}

