/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class ItemsExtension
extends NodeExtension
implements EmbeddedPacketExtension {
    protected ItemsElementType type;
    protected Boolean notify;
    protected List<? extends NamedElement> items;

    public ItemsExtension(ItemsElementType itemsType, String nodeId, List<? extends NamedElement> items) {
        super(itemsType.getNodeElement(), nodeId);
        this.type = itemsType;
        this.items = items;
    }

    public ItemsExtension(String nodeId, List<? extends ExtensionElement> items, boolean notify) {
        super(ItemsElementType.retract.getNodeElement(), nodeId);
        this.type = ItemsElementType.retract;
        this.items = items;
        this.notify = notify;
    }

    public ItemsElementType getItemsElementType() {
        return this.type;
    }

    @Override
    public List<XmlElement> getExtensions() {
        return this.getItems();
    }

    public List<? extends NamedElement> getItems() {
        return this.items;
    }

    public boolean getNotify() {
        return this.notify;
    }

    @Override
    protected void addXml(XmlStringBuilder xml) {
        if (this.items == null || this.items.size() == 0) {
            xml.closeEmptyElement();
            return;
        }
        if (this.notify != null) {
            xml.attribute(this.type.getElementAttribute(), this.notify.booleanValue());
            xml.rightAngleBracket();
        } else {
            xml.rightAngleBracket();
            xml.append(this.items);
        }
        xml.closeElement((NamedElement)this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "Content [" + this.toXML() + "]";
    }

    public static enum ItemsElementType {
        items(PubSubElementType.ITEMS, "max_items"),
        retract(PubSubElementType.RETRACT, "notify");

        private final PubSubElementType elem;
        private final String att;

        private ItemsElementType(PubSubElementType nodeElement, String attribute) {
            this.elem = nodeElement;
            this.att = attribute;
        }

        public PubSubElementType getNodeElement() {
            return this.elem;
        }

        public String getElementAttribute() {
            return this.att;
        }
    }
}

