/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.FlexibleStanzaTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.delay.DelayInformationManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.ConfigurationEvent;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemDeleteEvent;
import org.jivesoftware.smackx.pubsub.ItemPublishEvent;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.OptionsExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.RetractItem;
import org.jivesoftware.smackx.pubsub.SubscribeExtension;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.UnsubscribeExtension;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableSubscribeForm;
import org.jivesoftware.smackx.pubsub.form.SubscribeForm;
import org.jivesoftware.smackx.pubsub.listener.ItemDeleteListener;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;
import org.jivesoftware.smackx.pubsub.listener.NodeConfigListener;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.shim.packet.Header;
import org.jivesoftware.smackx.shim.packet.HeadersExtension;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class Node {
    protected final PubSubManager pubSubManager;
    protected final String id;
    protected ConcurrentHashMap<ItemEventListener<Item>, StanzaListener> itemEventToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<ItemDeleteListener, StanzaListener> itemDeleteToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<NodeConfigListener, StanzaListener> configEventToListenerMap = new ConcurrentHashMap();

    Node(PubSubManager pubSubManager, String nodeId) {
        this.pubSubManager = pubSubManager;
        this.id = nodeId;
    }

    public String getId() {
        return this.id;
    }

    public ConfigureForm getNodeConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.CONFIGURE_OWNER, this.getId()));
        PubSub reply = this.sendPubsubPacket(pubSub);
        return NodeUtils.getFormFromPacket((Stanza)reply, PubSubElementType.CONFIGURE_OWNER);
    }

    public void sendConfigurationForm(FillableConfigureForm configureForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.set, new FormNode(FormNodeType.CONFIGURE_OWNER, this.getId(), configureForm.getDataFormToSubmit()));
        this.pubSubManager.getConnection().sendIqRequestAndWaitForResponse((IQ)packet);
    }

    public DiscoverInfo discoverInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.pubSubManager.getConnection();
        DiscoverInfo discoverInfoRequest = ((DiscoverInfoBuilder)DiscoverInfo.builder(connection).to((Jid)this.pubSubManager.getServiceJid())).setNode(this.getId()).build();
        return (DiscoverInfo)connection.sendIqRequestAndWaitForResponse((IQ)discoverInfoRequest);
    }

    public List<Subscription> getSubscriptions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptions(null, null);
    }

    public List<Subscription> getSubscriptions(List<XmlElement> additionalExtensions, Collection<XmlElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace.basic, additionalExtensions, returnedExtensions);
    }

    public List<Subscription> getSubscriptionsAsOwner() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptionsAsOwner(null, null);
    }

    public List<Subscription> getSubscriptionsAsOwner(List<XmlElement> additionalExtensions, Collection<XmlElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace.owner, additionalExtensions, returnedExtensions);
    }

    private List<Subscription> getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace subscriptionsNamespace, List<XmlElement> additionalExtensions, Collection<XmlElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSubElementType pubSubElementType = subscriptionsNamespace.type;
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(pubSubElementType, this.getId()));
        if (additionalExtensions != null) {
            for (XmlElement pe : additionalExtensions) {
                pubSub.addExtension(pe);
            }
        }
        PubSub reply = this.sendPubsubPacket(pubSub);
        if (returnedExtensions != null) {
            returnedExtensions.addAll(reply.getExtensions());
        }
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtension(pubSubElementType);
        return subElem.getSubscriptions();
    }

    public PubSub modifySubscriptionsAsOwner(List<Subscription> changedSubs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new SubscriptionsExtension(SubscriptionsExtension.SubscriptionsNamespace.owner, this.getId(), changedSubs));
        return this.sendPubsubPacket(pubSub);
    }

    public List<Affiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliations(null, null);
    }

    public List<Affiliation> getAffiliations(List<XmlElement> additionalExtensions, Collection<XmlElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliations(Affiliation.AffiliationNamespace.basic, additionalExtensions, returnedExtensions);
    }

    public List<Affiliation> getAffiliationsAsOwner() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliationsAsOwner(null, null);
    }

    public List<Affiliation> getAffiliationsAsOwner(List<XmlElement> additionalExtensions, Collection<XmlElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliations(Affiliation.AffiliationNamespace.owner, additionalExtensions, returnedExtensions);
    }

    private List<Affiliation> getAffiliations(Affiliation.AffiliationNamespace affiliationsNamespace, List<XmlElement> additionalExtensions, Collection<XmlElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSubElementType pubSubElementType = affiliationsNamespace.type;
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(pubSubElementType, this.getId()));
        if (additionalExtensions != null) {
            for (XmlElement pe : additionalExtensions) {
                pubSub.addExtension(pe);
            }
        }
        PubSub reply = this.sendPubsubPacket(pubSub);
        if (returnedExtensions != null) {
            returnedExtensions.addAll(reply.getExtensions());
        }
        AffiliationsExtension affilElem = (AffiliationsExtension)reply.getExtension(pubSubElementType);
        return affilElem.getAffiliations();
    }

    public PubSub modifyAffiliationAsOwner(List<Affiliation> affiliations) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        for (Affiliation affiliation : affiliations) {
            if (affiliation.getPubSubNamespace() == PubSubNamespace.owner) continue;
            throw new IllegalArgumentException("Must use Affiliation(BareJid, Type) affiliations");
        }
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new AffiliationsExtension(Affiliation.AffiliationNamespace.owner, affiliations, this.getId()));
        return this.sendPubsubPacket(pubSub);
    }

    public Subscription subscribe(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension(jid, this.getId()));
        PubSub reply = this.sendPubsubPacket(pubSub);
        return (Subscription)reply.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    @Deprecated
    public Subscription subscribe(String jidString) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Jid jid;
        try {
            jid = JidCreate.from((String)jidString);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        return this.subscribe(jid);
    }

    public Subscription subscribe(Jid jid, FillableSubscribeForm subForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DataForm submitForm = subForm.getDataFormToSubmit();
        PubSub request = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension(jid, this.getId()));
        request.addExtension(new FormNode(FormNodeType.OPTIONS, submitForm));
        PubSub reply = this.sendPubsubPacket(request);
        return (Subscription)reply.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    @Deprecated
    public Subscription subscribe(String jidString, FillableSubscribeForm subForm) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Jid jid;
        try {
            jid = JidCreate.from((String)jidString);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        return this.subscribe(jid, subForm);
    }

    public void unsubscribe(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.unsubscribe(jid, null);
    }

    public void unsubscribe(String jid, String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.sendPubsubPacket(this.createPubsubPacket(IQ.Type.set, new UnsubscribeExtension(jid, this.getId(), subscriptionId)));
    }

    public SubscribeForm getSubscriptionOptions(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getSubscriptionOptions(jid, null);
    }

    public SubscribeForm getSubscriptionOptions(String jid, String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub packet = this.sendPubsubPacket(this.createPubsubPacket(IQ.Type.get, new OptionsExtension(jid, this.getId(), subscriptionId)));
        FormNode ext = (FormNode)packet.getExtension(PubSubElementType.OPTIONS);
        return new SubscribeForm(ext.getForm());
    }

    public void addItemEventListener(ItemEventListener listener) {
        ItemEventTranslator conListener = new ItemEventTranslator(listener);
        this.itemEventToListenerMap.put(listener, conListener);
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)conListener, (StanzaFilter)new EventContentFilter(EventElementType.items.toString(), "item"));
    }

    public void removeItemEventListener(ItemEventListener listener) {
        StanzaListener conListener = this.itemEventToListenerMap.remove(listener);
        if (conListener != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener(conListener);
        }
    }

    public void addConfigurationListener(NodeConfigListener listener) {
        NodeConfigTranslator conListener = new NodeConfigTranslator(listener);
        this.configEventToListenerMap.put(listener, conListener);
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)conListener, (StanzaFilter)new EventContentFilter(EventElementType.configuration.toString()));
    }

    public void removeConfigurationListener(NodeConfigListener listener) {
        StanzaListener conListener = this.configEventToListenerMap.remove(listener);
        if (conListener != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener(conListener);
        }
    }

    public void addItemDeleteListener(ItemDeleteListener listener) {
        ItemDeleteTranslator delListener = new ItemDeleteTranslator(listener);
        this.itemDeleteToListenerMap.put(listener, delListener);
        EventContentFilter deleteItem = new EventContentFilter(EventElementType.items.toString(), "retract");
        EventContentFilter purge = new EventContentFilter(EventElementType.purge.toString());
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)delListener, (StanzaFilter)new OrFilter(new StanzaFilter[]{deleteItem, purge}));
    }

    public void removeItemDeleteListener(ItemDeleteListener listener) {
        StanzaListener conListener = this.itemDeleteToListenerMap.remove(listener);
        if (conListener != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener(conListener);
        }
    }

    public String toString() {
        return super.toString() + " " + this.getClass().getName() + " id: " + this.id;
    }

    protected PubSub createPubsubPacket(IQ.Type type, NodeExtension ext) {
        return PubSub.createPubsubPacket((Jid)this.pubSubManager.getServiceJid(), type, ext);
    }

    protected PubSub sendPubsubPacket(PubSub packet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.pubSubManager.sendPubsubPacket(packet);
    }

    private static List<String> getSubscriptionIds(Stanza packet) {
        HeadersExtension headers = (HeadersExtension)packet.getExtension(HeadersExtension.class);
        ArrayList<String> values = null;
        if (headers != null) {
            values = new ArrayList<String>(headers.getHeaders().size());
            for (Header header : headers.getHeaders()) {
                values.add(header.getValue());
            }
        }
        return values;
    }

    class EventContentFilter
    extends FlexibleStanzaTypeFilter<Message> {
        private final String firstElement;
        private final String secondElement;
        private final boolean allowEmpty;

        EventContentFilter(String elementName) {
            this(elementName, null);
        }

        EventContentFilter(String firstLevelElement, String secondLevelElement) {
            this.firstElement = firstLevelElement;
            this.secondElement = secondLevelElement;
            this.allowEmpty = this.firstElement.equals(EventElementType.items.toString()) && "item".equals(secondLevelElement);
        }

        public boolean acceptSpecific(Message message) {
            EventElement event = EventElement.from((Stanza)message);
            if (event == null) {
                return false;
            }
            NodeExtension embedEvent = event.getEvent();
            if (embedEvent == null) {
                return false;
            }
            if (embedEvent.getElementName().equals(this.firstElement)) {
                if (!embedEvent.getNode().equals(Node.this.getId())) {
                    return false;
                }
                if (this.secondElement == null) {
                    return true;
                }
                if (embedEvent instanceof EmbeddedPacketExtension) {
                    List<XmlElement> secondLevelList = ((EmbeddedPacketExtension)((Object)embedEvent)).getExtensions();
                    if (this.allowEmpty && secondLevelList.isEmpty()) {
                        return true;
                    }
                    if (secondLevelList.size() > 0 && secondLevelList.get(0).getElementName().equals(this.secondElement)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class NodeConfigTranslator
    implements StanzaListener {
        private final NodeConfigListener listener;

        public NodeConfigTranslator(NodeConfigListener eventListener) {
            this.listener = eventListener;
        }

        public void processStanza(Stanza packet) {
            EventElement event = (EventElement)packet.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            ConfigurationEvent config = (ConfigurationEvent)event.getEvent();
            this.listener.handleNodeConfiguration(config);
        }
    }

    public static class ItemDeleteTranslator
    implements StanzaListener {
        private final ItemDeleteListener listener;

        public ItemDeleteTranslator(ItemDeleteListener eventListener) {
            this.listener = eventListener;
        }

        public void processStanza(Stanza packet) {
            EventElement event = (EventElement)packet.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            List<XmlElement> extList = event.getExtensions();
            if (extList.get(0).getElementName().equals(PubSubElementType.PURGE_EVENT.getElementName())) {
                this.listener.handlePurge();
            } else {
                ItemsExtension itemsElem = (ItemsExtension)event.getEvent();
                List<? extends NamedElement> pubItems = itemsElem.getItems();
                ArrayList<String> items = new ArrayList<String>(pubItems.size());
                for (RetractItem retractItem : pubItems) {
                    items.add(retractItem.getId());
                }
                ItemDeleteEvent eventItems = new ItemDeleteEvent(itemsElem.getNode(), items, Node.getSubscriptionIds(packet));
                this.listener.handleDeletedItems(eventItems);
            }
        }
    }

    public static class ItemEventTranslator
    implements StanzaListener {
        private final ItemEventListener listener;

        public ItemEventTranslator(ItemEventListener eventListener) {
            this.listener = eventListener;
        }

        public void processStanza(Stanza packet) {
            EventElement event = (EventElement)packet.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            ItemsExtension itemsElem = (ItemsExtension)event.getEvent();
            ItemPublishEvent<? extends NamedElement> eventItems = new ItemPublishEvent<NamedElement>(itemsElem.getNode(), itemsElem.getItems(), Node.getSubscriptionIds(packet), DelayInformationManager.getDelayTimestamp(packet));
            this.listener.handlePublishedItems(eventItems);
        }
    }
}

