/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.Whitebox;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InitiationListener;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class InitiationListenerTest
extends SmackTestSuite {
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final String sessionID = "session_id";
    private XMPPConnection connection;
    private InBandBytestreamManager byteStreamManager;
    private InitiationListener initiationListener;
    private Open initBytestream;

    @BeforeEach
    public void setup() {
        this.connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        this.byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        this.initiationListener = (InitiationListener)Whitebox.getInternalState((Object)this.byteStreamManager, (String)"initiationListener", InitiationListener.class);
        this.initBytestream = new Open(sessionID, 4096);
        this.initBytestream.setFrom((Jid)initiatorJID);
        this.initBytestream.setTo((Jid)targetJID);
    }

    @Test
    public void shouldRespondWithError() throws Exception {
        IQ response = this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Assertions.assertEquals((Object)initiatorJID, (Object)response.getTo());
        Assertions.assertEquals((Object)IQ.Type.error, (Object)response.getType());
        Assertions.assertEquals((Object)StanzaError.Condition.not_acceptable, (Object)response.getError().getCondition());
    }

    @Test
    public void shouldRejectRequestWithTooBigBlockSize() throws Exception {
        this.byteStreamManager.setMaximumBlockSize(1024);
        IQ response = this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Assertions.assertEquals((Object)initiatorJID, (Object)response.getTo());
        Assertions.assertEquals((Object)IQ.Type.error, (Object)response.getType());
        Assertions.assertEquals((Object)StanzaError.Condition.resource_constraint, (Object)response.getError().getCondition());
    }

    @Test
    public void shouldInvokeListenerForAllRequests() throws Exception {
        InBandBytestreamListener listener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)listener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assertions.assertEquals((Object)initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldInvokeListenerForUser() throws Exception {
        InBandBytestreamListener listener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, (Jid)initiatorJID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)listener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assertions.assertEquals((Object)initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldNotInvokeListenerForUser() throws Exception {
        InBandBytestreamListener listener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, JidCreate.from((String)("other_" + initiatorJID)));
        IQ response = this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assertions.assertEquals((Object)initiatorJID, (Object)response.getTo());
        Assertions.assertEquals((Object)IQ.Type.error, (Object)response.getType());
        Assertions.assertEquals((Object)StanzaError.Condition.not_acceptable, (Object)response.getError().getCondition());
    }

    @Test
    public void shouldNotInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        InBandBytestreamListener allRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        InBandBytestreamListener userRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, (Jid)initiatorJID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        InBandBytestreamListener allRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        InBandBytestreamListener userRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, JidCreate.from((String)("other_" + initiatorJID)));
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldIgnoreInBandBytestreamRequestOnce() throws Exception {
        InBandBytestreamListener allRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        InBandBytestreamListener userRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, (Jid)initiatorJID);
        this.byteStreamManager.ignoreBytestreamRequestOnce(sessionID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }
}

