/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.rsm.provider;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.rsm.packet.RSMSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RSMSetProviderTest
extends SmackTestSuite {
    @Test
    public void testRsmSetProvider() throws Exception {
        String rsmset = "<iq type='get' id='iqget'><pubsub xmlns='http://jabber.org/protocol/pubsub'><set xmlns='http://jabber.org/protocol/rsm'><after>aftervalue</after><before>beforevalue</before><count>1</count><first index='2'>foo@bar.com</first><index>3</index><last>lastvalue</last><max>4</max></set></pubsub></iq>";
        IQ iqWithRsm = (IQ)PacketParserUtils.parseStanza((String)"<iq type='get' id='iqget'><pubsub xmlns='http://jabber.org/protocol/pubsub'><set xmlns='http://jabber.org/protocol/rsm'><after>aftervalue</after><before>beforevalue</before><count>1</count><first index='2'>foo@bar.com</first><index>3</index><last>lastvalue</last><max>4</max></set></pubsub></iq>");
        RSMSet rsm = (RSMSet)iqWithRsm.getExtension(RSMSet.class);
        Assertions.assertNotNull((Object)rsm);
        Assertions.assertEquals((Object)"aftervalue", (Object)rsm.getAfter());
        Assertions.assertEquals((Object)"beforevalue", (Object)rsm.getBefore());
        Assertions.assertEquals((int)1, (int)rsm.getCount());
        Assertions.assertEquals((int)2, (int)rsm.getFirstIndex());
        Assertions.assertEquals((Object)"foo@bar.com", (Object)rsm.getFirst());
        Assertions.assertEquals((int)3, (int)rsm.getIndex());
        Assertions.assertEquals((Object)"lastvalue", (Object)rsm.getLast());
        Assertions.assertEquals((int)4, (int)rsm.getMax());
    }
}

