/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob.element;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.ContentId;

public class BoBDataExtension
implements ExtensionElement {
    public static final String ELEMENT = "data";
    public static final String NAMESPACE = "urn:xmpp:bob";
    private final ContentId cid;
    private final BoBData bobData;

    public BoBDataExtension(ContentId cid, BoBData bobData) {
        this.cid = (ContentId)Objects.requireNonNull((Object)cid);
        this.bobData = (BoBData)Objects.requireNonNull((Object)bobData);
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public final ContentId getContentId() {
        return this.cid;
    }

    public final BoBData getBobData() {
        return this.bobData;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((XmlElement)this);
        xml.attribute("cid", this.cid.getCid());
        xml.attribute("type", this.bobData.getType());
        xml.optAttribute("max-age", (Number)this.bobData.getMaxAge());
        xml.rightAngleBracket();
        xml.append((CharSequence)this.bobData.getContentBase64Encoded());
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static BoBDataExtension from(StanzaView stanza) {
        return (BoBDataExtension)stanza.getExtension(BoBDataExtension.class);
    }
}

