/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.packet;

import java.net.URI;
import java.util.Calendar;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.util.XmppDateTime;

public class GeoLocationTest
extends SmackTestSuite {
    @Test
    public void negativeTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT-830"));
        String tzo = XmppDateTime.asString((TimeZone)calendar.getTimeZone());
        GeoLocation geoLocation = GeoLocation.builder().setTzo(tzo).build();
        Assertions.assertEquals((Object)"-8:30", (Object)geoLocation.getTzo());
    }

    @Test
    public void positiveTimezonTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+530"));
        String tzo = XmppDateTime.asString((TimeZone)calendar.getTimeZone());
        GeoLocation geoLocation = GeoLocation.builder().setTzo(tzo).build();
        Assertions.assertEquals((Object)"+5:30", (Object)geoLocation.getTzo());
    }

    @Test
    public void accuracyTest() {
        GeoLocation geoLocation = GeoLocation.builder().setAccuracy(Double.valueOf(1.34)).build();
        Assertions.assertEquals((Double)1.34, (Double)geoLocation.getAccuracy());
    }

    @Test
    public void altAccuracyTest() {
        GeoLocation geoLocation = GeoLocation.builder().setAltAccuracy(Double.valueOf(1.52)).build();
        Assertions.assertEquals((Double)1.52, (Double)geoLocation.getAltAccuracy());
    }

    @Test
    public void toXMLMethodTest() throws Exception {
        String geoLocationMessageString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>");
        Assertions.assertNotNull((Object)messageWithGeoLocation);
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension(GeoLocation.class);
        Assertions.assertNotNull((Object)geoLocation);
        Assertions.assertNotNull((Object)geoLocation.toXML());
        GeoLocation constructedGeoLocation = GeoLocation.builder().setAccuracy(Double.valueOf(23.0)).setAlt(Double.valueOf(1000.0)).setAltAccuracy(Double.valueOf(10.0)).setArea("Delhi").setBearing(Double.valueOf(10.0)).setBuilding("Small Building").setCountry("India").setCountryCode("IN").setDescription("My Description").setError(Double.valueOf(90.0)).setFloor("top").setLat(Double.valueOf(25.098345)).setLocality("awesome").setLon(Double.valueOf(77.992034)).setPostalcode("110085").setRegion("North").setRoom("small").setSpeed(Double.valueOf(250.0)).setStreet("Wall Street").setText("Unit Testing GeoLocation").setTimestamp(XmppDateTime.parseDate((String)"2004-02-19")).setTzo("+5:30").setUri(new URI("http://xmpp.org")).build();
        Assertions.assertEquals((Object)constructedGeoLocation.toXML().toString(), (Object)geoLocation.toXML().toString());
    }
}

