/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import java.io.IOException;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muc.packet.GroupChatInvitation;
import org.jivesoftware.smackx.muc.provider.GroupChatInvitationProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

public class GroupChatInvitationElementTest {
    private static final GroupChatInvitationProvider TEST_PROVIDER = new GroupChatInvitationProvider();
    private static final EntityBareJid mucJid = JidCreate.entityBareFromOrThrowUnchecked((CharSequence)"darkcave@macbeth.shakespeare.lit");

    @Test
    public void serializeFullElement() throws XmlPullParserException, IOException, SmackParsingException {
        String expectedXml = "<x xmlns='jabber:x:conference'     continue='true'     jid='darkcave@macbeth.shakespeare.lit'     password='cauldronburn'     reason='Hey Hecate, this is the place for all good witches!'     thread='e0ffe42b28561960c6b12b944a092794b9683a38'/>";
        GroupChatInvitation invitation = new GroupChatInvitation(mucJid, "Hey Hecate, this is the place for all good witches!", "cauldronburn", true, "e0ffe42b28561960c6b12b944a092794b9683a38");
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<x xmlns='jabber:x:conference'     continue='true'     jid='darkcave@macbeth.shakespeare.lit'     password='cauldronburn'     reason='Hey Hecate, this is the place for all good witches!'     thread='e0ffe42b28561960c6b12b944a092794b9683a38'/>", (CharSequence)invitation.toXML());
        GroupChatInvitation parsed = (GroupChatInvitation)TEST_PROVIDER.parse(TestUtils.getParser((String)"<x xmlns='jabber:x:conference'     continue='true'     jid='darkcave@macbeth.shakespeare.lit'     password='cauldronburn'     reason='Hey Hecate, this is the place for all good witches!'     thread='e0ffe42b28561960c6b12b944a092794b9683a38'/>"));
        Assertions.assertEquals((Object)invitation, (Object)parsed);
    }

    @Test
    public void serializeMinimalElementTest() throws XmlPullParserException, IOException, SmackParsingException {
        String expectedXml = "<x xmlns='jabber:x:conference' jid='darkcave@macbeth.shakespeare.lit'/>";
        GroupChatInvitation invitation = new GroupChatInvitation(mucJid);
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<x xmlns='jabber:x:conference' jid='darkcave@macbeth.shakespeare.lit'/>", (CharSequence)invitation.toXML());
        GroupChatInvitation parsed = (GroupChatInvitation)TEST_PROVIDER.parse(TestUtils.getParser((String)"<x xmlns='jabber:x:conference' jid='darkcave@macbeth.shakespeare.lit'/>"));
        Assertions.assertEquals((Object)invitation, (Object)parsed);
    }
}

