/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.SimplePayload;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ItemValidationTest
extends SmackTestSuite {
    private ThreadedDummyConnection connection;

    @BeforeEach
    public void setUp() throws Exception {
        this.connection = new ThreadedDummyConnection();
        this.connection.connect();
        this.connection.login();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void verifyBasicItem() throws Exception {
        Item simpleItem = new Item();
        String simpleCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' />";
        XmlAssertUtil.assertXmlSimilar((CharSequence)simpleCtrl, (CharSequence)simpleItem.toXML().toString());
        Item idItem = new Item("uniqueid");
        String idCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='uniqueid'/>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)idCtrl, (CharSequence)idItem.toXML().toString());
        Item itemWithNodeId = new Item("testId", "testNode");
        String nodeIdCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='testId' node='testNode' />";
        XmlAssertUtil.assertXmlSimilar((CharSequence)nodeIdCtrl, (CharSequence)itemWithNodeId.toXML().toString());
    }

    @Test
    public void verifyPayloadItem() throws Exception {
        SimplePayload payload = new SimplePayload("<data xmlns='https://example.org'>This is the payload</data>");
        PayloadItem simpleItem = new PayloadItem((XmlElement)payload);
        String simpleCtrl = "<item xmlns='http://jabber.org/protocol/pubsub'>" + payload.toXML() + "</item>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)simpleCtrl, (CharSequence)simpleItem.toXML().toString());
        PayloadItem idItem = new PayloadItem("uniqueid", (XmlElement)payload);
        String idCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='uniqueid'>" + payload.toXML() + "</item>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)idCtrl, (CharSequence)idItem.toXML().toString());
        PayloadItem itemWithNodeId = new PayloadItem("testId", "testNode", (XmlElement)payload);
        String nodeIdCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='testId' node='testNode'>" + payload.toXML() + "</item>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)nodeIdCtrl, (CharSequence)itemWithNodeId.toXML().toString());
    }

    @Test
    public void parseBasicItem() throws Exception {
        XmlPullParser parser = PacketParserUtils.getParserFor((String)"<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' /></items></event></message>");
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        XmlElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        Assertions.assertTrue((boolean)(eventExt instanceof EventElement));
        EventElement event = (EventElement)eventExt;
        Assertions.assertEquals((Object)EventElementType.items, (Object)event.getEventType());
        Assertions.assertEquals((int)1, (int)event.getExtensions().size());
        Assertions.assertTrue((boolean)(event.getExtensions().get(0) instanceof ItemsExtension));
        Assertions.assertEquals((int)1, (int)((ItemsExtension)event.getExtensions().get((int)0)).items.size());
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assertions.assertTrue((boolean)(itemExt instanceof Item));
        Assertions.assertEquals((Object)"testid1", (Object)((Item)itemExt).getId());
    }

    @Test
    public void parseSimplePayloadItem() throws Exception {
        String itemContent = "<foo xmlns='smack:test'>Some text</foo>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item></items></event></message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        XmlElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        EventElement event = (EventElement)eventExt;
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assertions.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assertions.assertEquals((Object)"testid1", (Object)item.getId());
        Assertions.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        SimplePayload payload = (SimplePayload)item.getPayload();
        Assertions.assertEquals((Object)"foo", (Object)payload.getElementName());
        Assertions.assertEquals((Object)"smack:test", (Object)payload.getNamespace());
        XmlAssertUtil.assertXmlSimilar((CharSequence)itemContent, (CharSequence)payload.toXML().toString());
    }

    @Test
    public void parseComplexItem() throws Exception {
        String itemContent = "<entry xmlns='http://www.w3.org/2005/Atom'><title>Soliloquy</title><summary>To be, or not to be: that is the question:Whether 'tis nobler in the mind to sufferThe slings and arrows of outrageous fortune,Or to take arms against a sea of troubles,And by opposing end them?</summary><link rel='alternate' type='text/html' href='http://denmark.lit/2003/12/13/atom03'/><id>tag:denmark.lit,2003:entry-32397</id><published>2003-12-13T18:30:02Z</published><updated>2003-12-13T18:30:02Z</updated></entry>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item></items></event></message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        XmlElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        EventElement event = (EventElement)eventExt;
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assertions.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assertions.assertEquals((Object)"testid1", (Object)item.getId());
        Assertions.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        SimplePayload payload = (SimplePayload)item.getPayload();
        Assertions.assertEquals((Object)"entry", (Object)payload.getElementName());
        Assertions.assertEquals((Object)"http://www.w3.org/2005/Atom", (Object)payload.getNamespace());
        XmlAssertUtil.assertXmlSimilar((CharSequence)itemContent, (CharSequence)payload.toXML().toString());
    }

    @Test
    public void parseEmptyTag() throws Exception {
        String itemContent = "<foo xmlns='smack:test'><bar/></foo>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item></items></event></message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        XmlElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        Assertions.assertTrue((boolean)(eventExt instanceof EventElement));
        EventElement event = (EventElement)eventExt;
        Assertions.assertEquals((Object)EventElementType.items, (Object)event.getEventType());
        Assertions.assertEquals((int)1, (int)event.getExtensions().size());
        Assertions.assertTrue((boolean)(event.getExtensions().get(0) instanceof ItemsExtension));
        Assertions.assertEquals((int)1, (int)((ItemsExtension)event.getExtensions().get((int)0)).items.size());
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assertions.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assertions.assertEquals((Object)"testid1", (Object)item.getId());
        Assertions.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        XmlAssertUtil.assertXmlSimilar((CharSequence)itemContent, (CharSequence)item.getPayload().toXML().toString());
    }
}

