/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class SimplePayload
implements XmlElement {
    private final String elemName;
    private final String ns;
    private final String payload;

    public SimplePayload(String xmlPayload) {
        XmlPullParser parser;
        try {
            parser = PacketParserUtils.getParserFor((String)xmlPayload);
        }
        catch (IOException | XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
        QName qname = parser.getQName();
        this.payload = xmlPayload;
        this.elemName = (String)StringUtils.requireNotNullNorEmpty((CharSequence)qname.getLocalPart(), (String)"Could not determine element name from XML payload");
        this.ns = (String)StringUtils.requireNotNullNorEmpty((CharSequence)qname.getNamespaceURI(), (String)"Could not determine namespace from XML payload");
    }

    public String getElementName() {
        return this.elemName;
    }

    public String getNamespace() {
        return this.ns;
    }

    public String toXML(XmlEnvironment enclosingNamespace) {
        return this.payload;
    }

    public String toString() {
        return this.getClass().getName() + "payload [" + this.toXML() + "]";
    }
}

