/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.mood.provider.MoodProvider;
import org.jivesoftware.smackx.mood.provider.SimpleMoodConcretisationProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MoodConcretisationTest
extends SmackTestSuite {
    @Test
    public void concretisationTest() throws Exception {
        ProviderManager.addExtensionProvider((String)"ecstatic", (String)"https://example.org/", (Object)((Object)EcstaticMoodConcretisationProvider.INSTANCE));
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'><happy><ecstatic xmlns='https://example.org/'/></happy><text>Yay, the mood spec has been approved!</text></mood>";
        MoodElement element = new MoodElement(new MoodElement.MoodSubjectElement(Mood.happy, (MoodConcretisation)new EcstaticMoodConcretisation()), "Yay, the mood spec has been approved!");
        XmlAssertUtil.assertXmlSimilar((CharSequence)xml, (CharSequence)element.toXML().toString());
        XmlPullParser parser = TestUtils.getParser((String)xml);
        MoodElement parsed = (MoodElement)MoodProvider.INSTANCE.parse(parser);
        XmlAssertUtil.assertXmlSimilar((CharSequence)xml, (CharSequence)parsed.toXML().toString());
        Assertions.assertTrue((boolean)parsed.hasConcretisation());
        Assertions.assertTrue((boolean)parsed.hasText());
        Assertions.assertEquals((Object)"ecstatic", (Object)parsed.getMoodConcretisation().getMood());
    }

    @Test
    public void unknownConcretisationTest() throws Exception {
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'><sad><owl xmlns='https://reddit.com/r/superbowl/'/></sad><text>Hoot hoot!</text></mood>";
        XmlPullParser parser = TestUtils.getParser((String)xml);
        MoodElement element = (MoodElement)MoodProvider.INSTANCE.parse(parser);
        Assertions.assertFalse((boolean)element.hasConcretisation());
    }

    public static class EcstaticMoodConcretisationProvider
    extends SimpleMoodConcretisationProvider<EcstaticMoodConcretisation> {
        static EcstaticMoodConcretisationProvider INSTANCE = new EcstaticMoodConcretisationProvider();

        protected EcstaticMoodConcretisation simpleExtension() {
            return new EcstaticMoodConcretisation();
        }
    }

    public static class EcstaticMoodConcretisation
    extends MoodConcretisation {
        public static final String NAMESPACE = "https://example.org/";
        public static final String ELEMENT = "ecstatic";

        public String getNamespace() {
            return NAMESPACE;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }
}

