/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.WaitForPacketListener;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.packet.GroupChatInvitation;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class MultiUserChatTest
extends SmackTestSuite {
    private static final int RESPONSE_TIMEOUT_IN_MILLIS = 10000;
    private DummyConnection connection;
    private MultiUserChatManager multiUserChatManager;

    @BeforeEach
    public void setUp() throws Exception {
        this.connection = new DummyConnection();
        this.connection.connect();
        this.connection.login();
        this.multiUserChatManager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.connection);
    }

    @AfterEach
    public void tearDown() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    @Test
    public void testInviteDirectly() throws Throwable {
        final EntityBareJid roomJid = JidCreate.entityBareFrom((String)"room@example.com");
        final EntityBareJid userJid = JidCreate.entityBareFrom((String)"user@example.com");
        final AtomicBoolean updateRequestSent = new AtomicBoolean();
        InvokeDirectlyResponder serverSimulator = new InvokeDirectlyResponder(){

            @Override
            void verifyRequest(Message updateRequest) {
                Assertions.assertEquals((Object)userJid, (Object)updateRequest.getTo(), (String)"The provided JID doesn't match the request!");
                GroupChatInvitation groupChatInvitation = (GroupChatInvitation)updateRequest.getExtension("jabber:x:conference");
                Assertions.assertNotNull((Object)groupChatInvitation, (String)"Missing GroupChatInvitation extension");
                Assertions.assertEquals((Object)roomJid, (Object)groupChatInvitation.getRoomAddress());
                Assertions.assertNull((Object)groupChatInvitation.getReason());
                Assertions.assertNull((Object)groupChatInvitation.getPassword());
                Assertions.assertFalse((boolean)groupChatInvitation.continueAsOneToOneChat());
                Assertions.assertNull((Object)groupChatInvitation.getThread());
                updateRequestSent.set(true);
            }
        };
        serverSimulator.start();
        MultiUserChat multiUserChat = this.multiUserChatManager.getMultiUserChat(roomJid);
        multiUserChat.inviteDirectly(userJid);
        serverSimulator.join(10000L);
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        Assertions.assertTrue((boolean)updateRequestSent.get(), (String)"Invite directly request not sent");
    }

    @Test
    public void testInviteDirectlyWithAllOptionalAttributes() throws Throwable {
        final EntityBareJid roomJid = JidCreate.entityBareFrom((String)"room@example.com");
        final EntityBareJid userJid = JidCreate.entityBareFrom((String)"user@example.com");
        final String reason = "reason";
        final String password = "password";
        final boolean continueAsOneToOneChat = true;
        final String thread = "e0ffe42b28561960c6b12b944a092794b9683a38";
        final AtomicBoolean updateRequestSent = new AtomicBoolean();
        InvokeDirectlyResponder serverSimulator = new InvokeDirectlyResponder(){

            @Override
            void verifyRequest(Message updateRequest) {
                Assertions.assertEquals((Object)userJid, (Object)updateRequest.getTo(), (String)"The provided JID doesn't match the request!");
                GroupChatInvitation groupChatInvitation = (GroupChatInvitation)updateRequest.getExtension("jabber:x:conference");
                Assertions.assertNotNull((Object)groupChatInvitation, (String)"Missing GroupChatInvitation extension");
                Assertions.assertEquals((Object)roomJid, (Object)groupChatInvitation.getRoomAddress());
                Assertions.assertSame((Object)reason, (Object)groupChatInvitation.getReason());
                Assertions.assertSame((Object)password, (Object)groupChatInvitation.getPassword());
                Assertions.assertSame((Object)continueAsOneToOneChat, (Object)groupChatInvitation.continueAsOneToOneChat());
                Assertions.assertSame((Object)thread, (Object)groupChatInvitation.getThread());
                updateRequestSent.set(true);
            }
        };
        serverSimulator.start();
        MultiUserChat multiUserChat = this.multiUserChatManager.getMultiUserChat(roomJid);
        multiUserChat.inviteDirectly(userJid, reason, password, continueAsOneToOneChat, thread);
        serverSimulator.join(10000L);
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        Assertions.assertTrue((boolean)updateRequestSent.get(), (String)"Invite directly request not sent");
    }

    @Test
    public void shouldReceiveOfflineInvitation() throws XmppStringprepException, Throwable {
        final EntityBareJid roomJid = JidCreate.entityBareFrom((String)"room@example.com");
        final EntityFullJid inviterJid = JidCreate.entityFullFrom((CharSequence)"inviter@example.com/user1");
        EntityBareJid inviteeJid = JidCreate.entityBareFrom((String)"invitee@example.com");
        final MUCUser.Invite invite = new MUCUser.Invite(null, inviterJid);
        GroupChatInvitation groupChatInvitation = new GroupChatInvitation(roomJid);
        final Message sentMessage = ((MessageBuilder)((MessageBuilder)((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().from((Jid)inviterJid)).to((Jid)inviteeJid)).addExtension((XmlElement)groupChatInvitation)).build();
        GroupInvitationListener groupInvitationListener = new GroupInvitationListener(){

            @Override
            public void verifyInvitation(XMPPConnection conn, MultiUserChat room, EntityJid inviter, String reason, String password, Message message, MUCUser.Invite invitation) {
                try {
                    Assertions.assertSame((Object)MultiUserChatTest.this.connection, (Object)conn);
                    Assertions.assertSame((Object)MultiUserChatTest.this.connection, (Object)room.getXmppConnection());
                    Assertions.assertEquals((Object)roomJid, (Object)room.getRoom());
                    Assertions.assertEquals((Object)inviterJid, (Object)inviter);
                    Assertions.assertNull((Object)reason);
                    Assertions.assertNull((Object)password);
                    Assertions.assertSame((Object)sentMessage, (Object)message);
                    Assertions.assertEquals((Object)invite.getReason(), (Object)invitation.getReason());
                    Assertions.assertEquals((Object)invite.getFrom(), (Object)invitation.getFrom());
                }
                catch (Throwable e) {
                    this.setError(e);
                }
            }
        };
        this.multiUserChatManager.addInvitationListener((InvitationListener)groupInvitationListener);
        this.connection.processStanza((Stanza)sentMessage);
        groupInvitationListener.waitUntilInvocationOrTimeout();
        if (groupInvitationListener.getError() != null) {
            throw groupInvitationListener.getError();
        }
    }

    @Test
    public void shouldReceiveOfflineInvitationWithAllOptionalAttributes() throws XmppStringprepException, Throwable {
        final EntityBareJid roomJid = JidCreate.entityBareFrom((String)"room@example.com");
        final String expectedReason = "reason";
        final String expectedPassword = "password";
        boolean expectedContinueAsOneToOneChat = true;
        String expectedThread = "e0ffe42b28561960c6b12b944a092794b9683a38";
        final EntityFullJid inviterJid = JidCreate.entityFullFrom((CharSequence)"inviter@example.com/user1");
        EntityBareJid inviteeJid = JidCreate.entityBareFrom((String)"invitee@example.com");
        final MUCUser.Invite invite = new MUCUser.Invite(expectedReason, inviterJid);
        GroupChatInvitation groupChatInvitation = new GroupChatInvitation(roomJid, expectedReason, expectedPassword, expectedContinueAsOneToOneChat, expectedThread);
        final Message sentMessage = ((MessageBuilder)((MessageBuilder)((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().from((Jid)inviterJid)).to((Jid)inviteeJid)).addExtension((XmlElement)groupChatInvitation)).build();
        GroupInvitationListener groupInvitationListener = new GroupInvitationListener(){

            @Override
            public void verifyInvitation(XMPPConnection conn, MultiUserChat room, EntityJid inviter, String reason, String password, Message message, MUCUser.Invite invitation) {
                try {
                    Assertions.assertSame((Object)MultiUserChatTest.this.connection, (Object)conn);
                    Assertions.assertSame((Object)MultiUserChatTest.this.connection, (Object)room.getXmppConnection());
                    Assertions.assertEquals((Object)roomJid, (Object)room.getRoom());
                    Assertions.assertEquals((Object)inviterJid, (Object)inviter);
                    Assertions.assertEquals((Object)expectedReason, (Object)reason);
                    Assertions.assertEquals((Object)expectedPassword, (Object)password);
                    Assertions.assertSame((Object)sentMessage, (Object)message);
                    Assertions.assertEquals((Object)invite.getReason(), (Object)invitation.getReason());
                    Assertions.assertEquals((Object)invite.getFrom(), (Object)invitation.getFrom());
                }
                catch (Throwable e) {
                    this.setError(e);
                }
            }
        };
        this.multiUserChatManager.addInvitationListener((InvitationListener)groupInvitationListener);
        this.connection.processStanza((Stanza)sentMessage);
        groupInvitationListener.waitUntilInvocationOrTimeout();
        if (groupInvitationListener.getError() != null) {
            throw groupInvitationListener.getError();
        }
    }

    private static abstract class GroupInvitationListener
    extends WaitForPacketListener
    implements InvitationListener {
        protected volatile Throwable exception;

        private GroupInvitationListener() {
        }

        public abstract void verifyInvitation(XMPPConnection var1, MultiUserChat var2, EntityJid var3, String var4, String var5, Message var6, MUCUser.Invite var7);

        public void invitationReceived(XMPPConnection conn, MultiUserChat room, EntityJid inviter, String reason, String password, Message message, MUCUser.Invite invitation) {
            this.verifyInvitation(conn, room, inviter, reason, password, message, invitation);
            this.reportInvoked();
        }

        public synchronized Throwable getError() {
            return this.exception;
        }

        public synchronized void setError(Throwable e) {
            this.exception = e;
        }
    }

    private abstract class InvokeDirectlyResponder
    extends Thread {
        protected Throwable exception;

        private InvokeDirectlyResponder() {
        }

        abstract void verifyRequest(Message var1);

        @Override
        public void run() {
            try {
                Stanza stanza;
                while (!((stanza = (Stanza)MultiUserChatTest.this.connection.getSentPacket()) instanceof Message)) {
                }
                Message message = (Message)stanza;
                this.verifyRequest(message);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        Throwable getException() {
            return this.exception;
        }
    }
}

