/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.PubSubManagerTest;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public class ConfigureFormTest
extends SmackTestSuite {
    @Test
    public void getConfigFormWithInsufficientPrivileges() throws XMPPException, SmackException, IOException, InterruptedException {
        ThreadedDummyConnection con = ThreadedDummyConnection.newInstance();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con, (BareJid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        DiscoverInfoBuilder info = (DiscoverInfoBuilder)((DiscoverInfoBuilder)DiscoverInfo.builder((String)"disco-result").ofType(IQ.Type.result)).from((Jid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        DiscoverInfo.Identity ident = new DiscoverInfo.Identity("pubsub", null, "leaf");
        info.addIdentity(ident);
        DiscoverInfo discoverInfo = info.build();
        con.addIQReply((IQ)discoverInfo);
        Node node = mgr.getNode("princely_musings");
        PubSub errorIq = new PubSub();
        errorIq.setType(IQ.Type.error);
        errorIq.setFrom((Jid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        StanzaError error = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.forbidden).build();
        errorIq.setError(error);
        con.addIQReply((IQ)errorIq);
        try {
            node.getNodeConfiguration();
            Assertions.fail();
        }
        catch (XMPPException.XMPPErrorException e) {
            Assertions.assertEquals((Object)StanzaError.Type.AUTH, (Object)e.getStanzaError().getType());
        }
    }

    @Test
    public void getConfigFormWithTimeout() throws XMPPException, InterruptedException, SmackException, IOException {
        ThreadedDummyConnection con = ThreadedDummyConnection.newInstance();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con, (BareJid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        DiscoverInfoBuilder info = (DiscoverInfoBuilder)((DiscoverInfoBuilder)DiscoverInfo.builder((String)"disco-result").ofType(IQ.Type.result)).from((Jid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        DiscoverInfo.Identity ident = new DiscoverInfo.Identity("pubsub", null, "leaf");
        info.addIdentity(ident);
        DiscoverInfo discoverInfo = info.build();
        con.addIQReply((IQ)discoverInfo);
        Node node = mgr.getNode("princely_musings");
        SmackConfiguration.setDefaultReplyTimeout((int)100);
        con.setTimeout();
        Assertions.assertThrows(SmackException.class, () -> node.getNodeConfiguration());
    }
}

