/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.time.packet.Time;
import org.jivesoftware.smackx.time.packet.TimeBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeTest
extends SmackTestSuite {
    @Test
    public void parseCurrentTimeTest() {
        Calendar calendar = Calendar.getInstance();
        Time time = ((TimeBuilder)Time.builder((String)"dummy").ofType(IQ.Type.result)).setTime(calendar).build();
        Date date = time.getTime();
        Date calendarDate = calendar.getTime();
        Assertions.assertEquals((Object)calendarDate, (Object)date);
    }

    @Test
    public void negativeTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT-830"));
        Time time = ((TimeBuilder)Time.builder((String)"dummy").ofType(IQ.Type.result)).setTime(calendar).build();
        Assertions.assertEquals((Object)"-8:30", (Object)time.getTzo());
    }

    @Test
    public void positiveTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+830"));
        Time time = ((TimeBuilder)Time.builder((String)"dummy").ofType(IQ.Type.result)).setTime(calendar).build();
        Assertions.assertEquals((Object)"+8:30", (Object)time.getTzo());
    }
}

