/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.urldata;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.urldata.element.UrlDataElement;
import org.jivesoftware.smackx.urldata.http.element.CookieElement;
import org.jivesoftware.smackx.urldata.http.element.HeaderElement;
import org.jivesoftware.smackx.urldata.http.element.HttpAuthElement;
import org.jivesoftware.smackx.urldata.provider.UrlDataElementProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlDataElementTest
extends SmackTestSuite {
    public static final UrlDataElementProvider URL_DATA_ELEMENT_PROVIDER = new UrlDataElementProvider();

    @Test
    public void simpleSerializationTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("http://www.jabber.org/members/index.php", null, Collections.singletonList(HttpAuthElement.basicAuth()), null, null);
        String expectedXml = "<url-data xmlns='http://jabber.org/protocol/url-data' xmlns:http='http://jabber.org/protocol/url-data/scheme/http' target='http://www.jabber.org/members/index.php'><http:auth scheme='basic'/></url-data>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data xmlns='http://jabber.org/protocol/url-data' xmlns:http='http://jabber.org/protocol/url-data/scheme/http' target='http://www.jabber.org/members/index.php'><http:auth scheme='basic'/></url-data>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data xmlns='http://jabber.org/protocol/url-data' xmlns:http='http://jabber.org/protocol/url-data/scheme/http' target='http://www.jabber.org/members/index.php'><http:auth scheme='basic'/></url-data>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }

    @Test
    public void additionalAuthParamTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("http://www.jabber.org/members/index.php", null, Collections.singletonList(HttpAuthElement.basicAuth((String)"www.jabber.org", (String)"defaultuser", (String)"defaultpwd")), null, null);
        String expectedXml = "<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n    <http:auth scheme='basic'>\n      <http:auth-param name='realm' value='www.jabber.org'/>\n      <http:auth-param name='username' value='defaultuser'/>\n      <http:auth-param name='password' value='defaultpwd'/>\n    </http:auth>\n  </url-data>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n    <http:auth scheme='basic'>\n      <http:auth-param name='realm' value='www.jabber.org'/>\n      <http:auth-param name='username' value='defaultuser'/>\n      <http:auth-param name='password' value='defaultpwd'/>\n    </http:auth>\n  </url-data>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n    <http:auth scheme='basic'>\n      <http:auth-param name='realm' value='www.jabber.org'/>\n      <http:auth-param name='username' value='defaultuser'/>\n      <http:auth-param name='password' value='defaultpwd'/>\n    </http:auth>\n  </url-data>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }

    @Test
    public void simpleUrlWithSidTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("http://pass.jabber.org:8519/test.txt", "a0");
        String expectedXml = "<url-data xmlns='http://jabber.org/protocol/url-data'\n      sid='a0'\n      target='http://pass.jabber.org:8519/test.txt'/>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      sid='a0'\n      target='http://pass.jabber.org:8519/test.txt'/>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      sid='a0'\n      target='http://pass.jabber.org:8519/test.txt'/>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }

    @Test
    public void simpleUrlNoChildrenTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("http://festhall.outer-planes.net/d20M/announce/latest/", null);
        String expectedXml = "<url-data\n      xmlns='http://jabber.org/protocol/url-data'\n      target='http://festhall.outer-planes.net/d20M/announce/latest/'/>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data\n      xmlns='http://jabber.org/protocol/url-data'\n      target='http://festhall.outer-planes.net/d20M/announce/latest/'/>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data\n      xmlns='http://jabber.org/protocol/url-data'\n      target='http://festhall.outer-planes.net/d20M/announce/latest/'/>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }

    @Test
    public void simpleCookieTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("http://www.jabber.org/members/index.php", null, null, Collections.singletonList(new CookieElement("jsessionid", "1243asd234190sa32ds")), null);
        String expectedXml = "<url-data xmlns='http://jabber.org/protocol/url-data'\n    xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n    target='http://www.jabber.org/members/index.php'>\n  <http:cookie name='jsessionid' value='1243asd234190sa32ds'/>\n</url-data>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data xmlns='http://jabber.org/protocol/url-data'\n    xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n    target='http://www.jabber.org/members/index.php'>\n  <http:cookie name='jsessionid' value='1243asd234190sa32ds'/>\n</url-data>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data xmlns='http://jabber.org/protocol/url-data'\n    xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n    target='http://www.jabber.org/members/index.php'>\n  <http:cookie name='jsessionid' value='1243asd234190sa32ds'/>\n</url-data>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }

    @Test
    public void additionalParametersCookieTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("http://www.jabber.org/members/index.php", null, null, Collections.singletonList(new CookieElement("jsessionid", "1243asd234190sa32ds", "jabber.org", Integer.valueOf(1234000), "/members", "Web Session Identifier", "1.0", Boolean.valueOf(false))), null);
        String expectedXml = "<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n  <http:cookie name='jsessionid'\n        domain='jabber.org'\n        max-age='1234000'\n        path='/members'\n        comment='Web Session Identifier'\n        version='1.0'\n        secure='false'\n        value='1243asd234190sa32ds'/>\n</url-data>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n  <http:cookie name='jsessionid'\n        domain='jabber.org'\n        max-age='1234000'\n        path='/members'\n        comment='Web Session Identifier'\n        version='1.0'\n        secure='false'\n        value='1243asd234190sa32ds'/>\n</url-data>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n  <http:cookie name='jsessionid'\n        domain='jabber.org'\n        max-age='1234000'\n        path='/members'\n        comment='Web Session Identifier'\n        version='1.0'\n        secure='false'\n        value='1243asd234190sa32ds'/>\n</url-data>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }

    @Test
    public void simpleHeaderTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("http://www.jabber.org/members/index.php", null, null, null, Collections.singletonList(new HeaderElement("Custom-Data", "some custom data")));
        String expectedXml = "<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n    <http:header name='Custom-Data' value='some custom data'/>\n  </url-data>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n    <http:header name='Custom-Data' value='some custom data'/>\n  </url-data>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='http://www.jabber.org/members/index.php'>\n    <http:header name='Custom-Data' value='some custom data'/>\n  </url-data>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }

    @Test
    public void multiChildTest() throws XmlPullParserException, IOException, SmackParsingException {
        UrlDataElement urlDataElement = new UrlDataElement("https://blog.jabberhead.tk", null, Collections.singletonList(HttpAuthElement.basicAuth()), Arrays.asList(new CookieElement("jsessionid", "somecookievalue"), new CookieElement("come2darkSide", "weHaveCookies")), Arrays.asList(new HeaderElement("Accept", "text/plain"), new HeaderElement("Access-Control-Allow-Origin", "*")));
        String expectedXml = "<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='https://blog.jabberhead.tk'>\n    <http:auth scheme='basic'/>\n    <http:cookie name='jsessionid' value='somecookievalue'/>\n    <http:cookie name='come2darkSide' value='weHaveCookies'/>\n    <http:header name='Accept' value='text/plain'/>\n    <http:header name='Access-Control-Allow-Origin' value='*'/>\n  </url-data>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='https://blog.jabberhead.tk'>\n    <http:auth scheme='basic'/>\n    <http:cookie name='jsessionid' value='somecookievalue'/>\n    <http:cookie name='come2darkSide' value='weHaveCookies'/>\n    <http:header name='Accept' value='text/plain'/>\n    <http:header name='Access-Control-Allow-Origin' value='*'/>\n  </url-data>", (CharSequence)urlDataElement.toXML().toString());
        UrlDataElement parsed = (UrlDataElement)URL_DATA_ELEMENT_PROVIDER.parse(TestUtils.getParser((String)"<url-data xmlns='http://jabber.org/protocol/url-data'\n      xmlns:http='http://jabber.org/protocol/url-data/scheme/http'\n      target='https://blog.jabberhead.tk'>\n    <http:auth scheme='basic'/>\n    <http:cookie name='jsessionid' value='somecookievalue'/>\n    <http:cookie name='come2darkSide' value='weHaveCookies'/>\n    <http:header name='Accept' value='text/plain'/>\n    <http:header name='Access-Control-Allow-Origin' value='*'/>\n  </url-data>"));
        Assertions.assertEquals((Object)urlDataElement, (Object)parsed);
    }
}

