/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim.provider;

import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jivesoftware.smack.test.util.CharSequenceEquals;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xhtmlim.packet.XHTMLExtension;
import org.jivesoftware.smackx.xhtmlim.provider.XHTMLExtensionProvider;
import org.junit.jupiter.api.Test;

public class XHTMLExtensionProviderTest {
    public static final String XHTML_EXTENSION_SAMPLE_RESOURCE_NAME = "xhtml.xml";

    @Test
    public void parsesWell() throws IOException, XmlPullParserException {
        InputStream inputStream = this.getClass().getResourceAsStream(XHTML_EXTENSION_SAMPLE_RESOURCE_NAME);
        XmlPullParser parser = PacketParserUtils.getParserFor((InputStream)inputStream);
        XHTMLExtensionProvider provider = new XHTMLExtensionProvider();
        XHTMLExtension extension = provider.parse(parser, parser.getDepth(), null);
        MatcherAssert.assertThat((Object)extension, (Matcher)CoreMatchers.instanceOf(XHTMLExtension.class));
        XHTMLExtension attachmentsInfo = extension;
        MatcherAssert.assertThat((Object)XHTMLExtensionProviderTest.sampleXhtml(), (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)((CharSequence)attachmentsInfo.getBodies().get(0))));
    }

    private static String sampleXhtml() {
        return "<body xmlns='http://www.w3.org/1999/xhtml'><span style='color: rgb(0, 0, 0); font-family: sans-serif, &apos;trebuchet ms&apos;, &apos;lucida grande&apos;, &apos;lucida sans unicode&apos;, arial, helvetica, sans-serif; font-weight: 600; line-height: 18px;'>Generic family<br/>AnotherLine</span></body>";
    }
}

