/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandHandler;
import org.jivesoftware.smackx.commands.AdHocCommandHandlerFactory;
import org.jivesoftware.smackx.commands.AdHocCommandResult;
import org.jivesoftware.smackx.commands.SpecificErrorCondition;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataBuilder;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.form.SubmitForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class AdHocCommandManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/commands";
    private static final Logger LOGGER = Logger.getLogger(AdHocCommandManager.class.getName());
    private static int DEFAULT_SESSION_TIMEOUT_SECS = 420;
    private static final Map<XMPPConnection, AdHocCommandManager> instances = new WeakHashMap<XMPPConnection, AdHocCommandManager>();
    private final ConcurrentHashMap<String, AdHocCommandInfo> commands = new ConcurrentHashMap();
    private final Map<String, AdHocCommandHandler> executingCommands = new ConcurrentHashMap<String, AdHocCommandHandler>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private int sessionTimeoutSecs = DEFAULT_SESSION_TIMEOUT_SECS;
    private boolean sessionSweeperScheduled;

    @Deprecated
    public static AdHocCommandManager getAddHocCommandsManager(XMPPConnection connection) {
        return AdHocCommandManager.getInstance(connection);
    }

    public static synchronized AdHocCommandManager getInstance(XMPPConnection connection) {
        AdHocCommandManager ahcm = instances.get(connection);
        if (ahcm == null) {
            ahcm = new AdHocCommandManager(connection);
            instances.put(connection, ahcm);
        }
        return ahcm;
    }

    private AdHocCommandManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(NAMESPACE);
        ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(NAMESPACE, new AbstractNodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                Collection commandsList = AdHocCommandManager.this.commands.values();
                EntityFullJid ourJid = AdHocCommandManager.this.connection().getUser();
                if (ourJid == null) {
                    LOGGER.warning("Local connection JID not available, can not respond to http://jabber.org/protocol/commands node information");
                    return null;
                }
                for (AdHocCommandInfo info : commandsList) {
                    DiscoverItems.Item item = new DiscoverItems.Item((Jid)ourJid);
                    item.setName(info.getName());
                    item.setNode(info.getNode());
                    answer.add(item);
                }
                return answer;
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("command", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                AdHocCommandData requestData = (AdHocCommandData)iqRequest;
                AdHocCommandData response = AdHocCommandManager.this.processAdHocCommand(requestData);
                assert (response.getStatus() != null || response.getType() == IQ.Type.error);
                return response;
            }
        });
    }

    public void registerCommand(String node, String name, Class<? extends AdHocCommandHandler> clazz) throws NoSuchMethodException, SecurityException {
        final Constructor<? extends AdHocCommandHandler> constructor = clazz.getConstructor(String.class, String.class, String.class);
        this.registerCommand(node, name, new AdHocCommandHandlerFactory(){

            @Override
            public AdHocCommandHandler create(String node, String name, String sessionId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                return (AdHocCommandHandler)constructor.newInstance(node, name, sessionId);
            }
        });
    }

    public synchronized void registerCommand(String node, final String name, AdHocCommandHandlerFactory factory) {
        AdHocCommandInfo commandInfo = new AdHocCommandInfo(node, name, factory);
        AdHocCommandInfo existing = this.commands.putIfAbsent(node, commandInfo);
        if (existing != null) {
            throw new IllegalArgumentException("There is already an ad-hoc command registered for " + node);
        }
        this.serviceDiscoveryManager.setNodeInformationProvider(node, new AbstractNodeInformationProvider(){

            @Override
            public List<String> getNodeFeatures() {
                ArrayList<String> answer = new ArrayList<String>();
                answer.add(AdHocCommandManager.NAMESPACE);
                answer.add("jabber:x:data");
                return answer;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                ArrayList<DiscoverInfo.Identity> answer = new ArrayList<DiscoverInfo.Identity>();
                DiscoverInfo.Identity identity = new DiscoverInfo.Identity("automation", name, "command-node");
                answer.add(identity);
                return answer;
            }
        });
    }

    public synchronized boolean unregisterCommand(String node) {
        AdHocCommandInfo commandInfo = this.commands.remove(node);
        if (commandInfo == null) {
            return false;
        }
        this.serviceDiscoveryManager.removeNodeInformationProvider(node);
        return true;
    }

    public DiscoverItems discoverCommands(Jid jid) throws XMPPException, SmackException, InterruptedException {
        return this.serviceDiscoveryManager.discoverItems(jid, NAMESPACE);
    }

    public AdHocCommand getRemoteCommand(Jid jid, String node) {
        return new AdHocCommand(this.connection(), node, jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdHocCommandData processAdHocCommand(AdHocCommandData request) {
        AdHocCommandData response;
        AdHocCommandHandler command;
        String sessionId = request.getSessionId();
        if (sessionId == null) {
            String commandNode = request.getNode();
            AdHocCommandInfo commandInfo = this.commands.get(commandNode);
            if (commandInfo == null) {
                return AdHocCommandManager.respondError(request, null, StanzaError.Condition.item_not_found);
            }
            assert (commandInfo.getNode().equals(commandNode));
            try {
                command = commandInfo.getCommandInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LOGGER.log(Level.WARNING, "Could not instanciate ad-hoc command server", e);
                StanzaError xmppError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.internal_server_error).setDescriptiveEnText(e.getMessage())).build();
                return AdHocCommandManager.respondError(request, null, xmppError);
            }
        } else {
            command = this.executingCommands.get(sessionId);
            if (command == null) {
                return AdHocCommandManager.respondError(request, null, StanzaError.Condition.bad_request, SpecificErrorCondition.badSessionid);
            }
        }
        AdHocCommandDataBuilder responseBuilder = AdHocCommandDataBuilder.buildResponseFor(request).setSessionId(command.getSessionId());
        AdHocCommandHandler adHocCommandHandler = command;
        synchronized (adHocCommandHandler) {
            command.addRequest(request);
            response = sessionId == null ? this.processAdHocCommandOfNewSession(request, command, responseBuilder) : this.processAdHocCommandOfExistingSession(request, command, responseBuilder);
            AdHocCommandResult commandResult = AdHocCommandResult.from(response);
            command.addResult(commandResult);
        }
        return response;
    }

    private AdHocCommandData createResponseFrom(AdHocCommandData request, AdHocCommandDataBuilder response, XMPPException.XMPPErrorException exception, String sessionId) {
        StanzaError error = exception.getStanzaError();
        if (error.getType() == StanzaError.Type.CANCEL) {
            response.setStatus(AdHocCommandData.Status.canceled);
            this.executingCommands.remove(sessionId);
            return response.build();
        }
        return AdHocCommandManager.respondError(request, response, error);
    }

    private static AdHocCommandData createResponseFrom(AdHocCommandData request, AdHocCommandDataBuilder response, Exception exception) {
        StanzaError error = StanzaError.from((StanzaError.Condition)StanzaError.Condition.internal_server_error, (String)exception.getMessage()).build();
        return AdHocCommandManager.respondError(request, response, error);
    }

    private AdHocCommandData processAdHocCommandOfNewSession(AdHocCommandData request, AdHocCommandHandler command, AdHocCommandDataBuilder responseBuilder) {
        AdHocCommandData response;
        if (!command.hasPermission(request.getFrom())) {
            return AdHocCommandManager.respondError(request, responseBuilder, StanzaError.Condition.forbidden);
        }
        AdHocCommandData.Action action = request.getAction();
        if (action != null && !action.equals((Object)AdHocCommandData.Action.execute)) {
            return AdHocCommandManager.respondError(request, responseBuilder, StanzaError.Condition.bad_request, SpecificErrorCondition.badAction);
        }
        command.incrementStage();
        try {
            response = command.execute(responseBuilder);
        }
        catch (XMPPException.XMPPErrorException e) {
            return this.createResponseFrom(request, responseBuilder, e, command.getSessionId());
        }
        catch (IllegalStateException | InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            return AdHocCommandManager.createResponseFrom(request, responseBuilder, (Exception)e);
        }
        if (response.isExecuting()) {
            this.executingCommands.put(command.getSessionId(), command);
            this.maybeWindUpSessionSweeper();
        }
        return response;
    }

    private AdHocCommandData processAdHocCommandOfExistingSession(AdHocCommandData request, AdHocCommandHandler command, AdHocCommandDataBuilder responseBuilder) {
        AdHocCommandData response;
        AdHocCommandData.AllowedAction executeAction;
        long creationStamp = command.getCreationDate();
        if (System.currentTimeMillis() - creationStamp > (long)(this.sessionTimeoutSecs * 1000)) {
            this.executingCommands.remove(command.getSessionId());
            return AdHocCommandManager.respondError(request, responseBuilder, StanzaError.Condition.not_allowed, SpecificErrorCondition.sessionExpired);
        }
        AdHocCommandData.Action action = request.getAction();
        if ((action == null || AdHocCommandData.Action.execute.equals((Object)action)) && (executeAction = command.getExecuteAction()) != null) {
            action = executeAction.action;
        }
        if (!command.isValidAction(action)) {
            return AdHocCommandManager.respondError(request, responseBuilder, StanzaError.Condition.bad_request, SpecificErrorCondition.badAction);
        }
        try {
            switch (action) {
                case next: {
                    command.incrementStage();
                    DataForm dataForm = request.getForm();
                    response = command.next(responseBuilder, new SubmitForm(dataForm));
                    break;
                }
                case complete: {
                    command.incrementStage();
                    DataForm dataForm = request.getForm();
                    responseBuilder.setStatus(AdHocCommandData.Status.completed);
                    response = command.complete(responseBuilder, new SubmitForm(dataForm));
                    this.executingCommands.remove(command.getSessionId());
                    break;
                }
                case prev: {
                    command.decrementStage();
                    response = command.prev(responseBuilder);
                    break;
                }
                case cancel: {
                    command.cancel();
                    responseBuilder.setStatus(AdHocCommandData.Status.canceled);
                    response = responseBuilder.build();
                    this.executingCommands.remove(command.getSessionId());
                    break;
                }
                default: {
                    return AdHocCommandManager.respondError(request, responseBuilder, StanzaError.Condition.bad_request, SpecificErrorCondition.badAction);
                }
            }
        }
        catch (XMPPException.XMPPErrorException e) {
            return this.createResponseFrom(request, responseBuilder, e, command.getSessionId());
        }
        catch (IllegalStateException | InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            return AdHocCommandManager.createResponseFrom(request, responseBuilder, (Exception)e);
        }
        return response;
    }

    private int getSessionRemovalTimeoutSecs() {
        return this.sessionTimeoutSecs * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionSweeper() {
        long currentTime = System.currentTimeMillis();
        AdHocCommandManager adHocCommandManager = this;
        synchronized (adHocCommandManager) {
            Iterator<Map.Entry<String, AdHocCommandHandler>> it = this.executingCommands.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, AdHocCommandHandler> entry = it.next();
                AdHocCommandHandler command = entry.getValue();
                long creationStamp = command.getCreationDate();
                if (currentTime - creationStamp <= (long)(this.getSessionRemovalTimeoutSecs() * 1000)) continue;
                it.remove();
            }
            this.sessionSweeperScheduled = false;
        }
        if (!this.executingCommands.isEmpty()) {
            this.maybeWindUpSessionSweeper();
        }
    }

    private synchronized void maybeWindUpSessionSweeper() {
        if (this.sessionSweeperScheduled) {
            return;
        }
        this.sessionSweeperScheduled = true;
        AdHocCommandManager.schedule(this::sessionSweeper, (long)(this.getSessionRemovalTimeoutSecs() + 1), (TimeUnit)TimeUnit.SECONDS);
    }

    private static AdHocCommandData respondError(AdHocCommandData request, AdHocCommandDataBuilder response, StanzaError.Condition condition) {
        return AdHocCommandManager.respondError(request, response, StanzaError.getBuilder((StanzaError.Condition)condition).build());
    }

    private static AdHocCommandData respondError(AdHocCommandData request, AdHocCommandDataBuilder response, StanzaError.Condition condition, SpecificErrorCondition specificCondition) {
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder((StanzaError.Condition)condition).addExtension((XmlElement)new AdHocCommandData.SpecificError(specificCondition))).build();
        return AdHocCommandManager.respondError(request, response, error);
    }

    private static AdHocCommandData respondError(AdHocCommandData request, AdHocCommandDataBuilder response, StanzaError error) {
        if (response == null) {
            return ((AdHocCommandDataBuilder)AdHocCommandDataBuilder.buildResponseFor(request, IQ.ResponseType.error).setError(error)).build();
        }
        return ((AdHocCommandDataBuilder)((AdHocCommandDataBuilder)response.ofType(IQ.Type.error)).setError(error)).build();
    }

    public static void setDefaultSessionTimeoutSecs(int seconds) {
        if (seconds < 10) {
            throw new IllegalArgumentException();
        }
        DEFAULT_SESSION_TIMEOUT_SECS = seconds;
    }

    public void setSessionTimeoutSecs(int seconds) {
        if (seconds < 10) {
            throw new IllegalArgumentException();
        }
        this.sessionTimeoutSecs = seconds;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                AdHocCommandManager.getInstance(connection);
            }
        });
    }

    private final class AdHocCommandInfo {
        private final String node;
        private final String name;
        private final AdHocCommandHandlerFactory factory;
        private static final int MAX_SESSION_GEN_ATTEMPTS = 3;

        private AdHocCommandInfo(String node, String name, AdHocCommandHandlerFactory factory) {
            this.node = node;
            this.name = name;
            this.factory = factory;
        }

        public AdHocCommandHandler getCommandInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String sessionId;
            int attempt = 0;
            do {
                if (++attempt > 3) {
                    throw new RuntimeException("Failed to compute unique session ID");
                }
                sessionId = StringUtils.randomString((int)15);
            } while (AdHocCommandManager.this.executingCommands.containsKey(sessionId));
            return this.factory.create(this.node, this.name, sessionId);
        }

        public String getName() {
            return this.name;
        }

        public String getNode() {
            return this.node;
        }
    }
}

