/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;
import org.jivesoftware.smackx.caps.CapsVersionAndHash;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.cache.SimpleDirectoryPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextMultiFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class EntityCapsManagerTest
extends SmackTestSuite {
    @Test
    public void testSimpleGenerationExample() throws XmppStringprepException {
        DiscoverInfo di = EntityCapsManagerTest.createSimpleSamplePacket();
        CapsVersionAndHash versionAndHash = EntityCapsManager.generateVerificationString((DiscoverInfoView)di, (String)"SHA-1");
        Assertions.assertEquals((Object)"QgayPKawpkPSDYmwT/WM94uAlu0=", (Object)versionAndHash.version);
    }

    @Test
    public void testReversedDataFormOrder() throws XmppStringprepException {
        DiscoverInfoBuilder builderA = EntityCapsManagerTest.createSimpleSampleBuilder();
        builderA.addExtension((XmlElement)EntityCapsManagerTest.createSampleServerInfoDataForm());
        builderA.addExtension((XmlElement)EntityCapsManagerTest.createSampleSoftwareInfoDataForm());
        DiscoverInfoBuilder builderB = EntityCapsManagerTest.createSimpleSampleBuilder();
        builderB.addExtension((XmlElement)EntityCapsManagerTest.createSampleSoftwareInfoDataForm());
        builderB.addExtension((XmlElement)EntityCapsManagerTest.createSampleServerInfoDataForm());
        CapsVersionAndHash versionAndHashA = EntityCapsManager.generateVerificationString((DiscoverInfoView)builderA.build(), (String)"SHA-1");
        CapsVersionAndHash versionAndHashB = EntityCapsManager.generateVerificationString((DiscoverInfoView)builderB.build(), (String)"SHA-1");
        Assertions.assertEquals((Object)versionAndHashA.version, (Object)versionAndHashB.version);
    }

    @Test
    public void testComplexGenerationExample() throws XmppStringprepException {
        DiscoverInfo di = EntityCapsManagerTest.createComplexSamplePacket();
        CapsVersionAndHash versionAndHash = EntityCapsManager.generateVerificationString((DiscoverInfoView)di, (String)"SHA-1");
        Assertions.assertEquals((Object)"q07IKJEyjvHSyhy//CH0CxmKi8w=", (Object)versionAndHash.version);
    }

    @Test
    public void testSimpleDirectoryCacheBase32() throws IOException {
        EntityCapsManager.persistentCache = null;
        EntityCapsManagerTest.testSimpleDirectoryCache((StringEncoder<String>)Base32.getStringEncoder());
    }

    @Test
    public void testVerificationDuplicateFeatures() throws XmppStringprepException {
        DiscoverInfo di = EntityCapsManagerTest.createMalformedDiscoverInfo();
        Assertions.assertTrue((boolean)di.containsDuplicateFeatures());
    }

    @Test
    public void testVerificationDuplicateIdentities() throws XmppStringprepException {
        DiscoverInfo di = EntityCapsManagerTest.createMalformedDiscoverInfo();
        Assertions.assertTrue((boolean)di.containsDuplicateIdentities());
    }

    private static void testSimpleDirectoryCache(StringEncoder<String> stringEncoder) throws IOException {
        SimpleDirectoryPersistentCache cache = new SimpleDirectoryPersistentCache(EntityCapsManagerTest.createTempDirectory());
        EntityCapsManager.setPersistentCache((EntityCapsPersistentCache)cache);
        DiscoverInfo di = EntityCapsManagerTest.createComplexSamplePacket();
        CapsVersionAndHash versionAndHash = EntityCapsManager.generateVerificationString((DiscoverInfoView)di, (String)"SHA-1");
        String nodeVer = di.getNode() + "#" + versionAndHash.version;
        EntityCapsManager.addDiscoverInfoByNode((String)nodeVer, (DiscoverInfo)di);
        EntityCapsManager.clearMemoryCache();
        DiscoverInfo restored_di = EntityCapsManager.getDiscoveryInfoByNodeVer((String)nodeVer);
        Assertions.assertNotNull((Object)restored_di);
        Assertions.assertEquals((Object)di.toXML().toString(), (Object)restored_di.toXML().toString());
    }

    private static DataForm createSampleSoftwareInfoDataForm() {
        DataForm.Builder df = DataForm.builder((DataForm.Type)DataForm.Type.result);
        TextSingleFormField.Builder ff = FormField.builder((String)"os");
        ff.setValue((CharSequence)"Mac");
        df.addField((FormField)ff.build());
        ff = FormField.hiddenBuilder((String)"FORM_TYPE");
        ff.setValue((CharSequence)"urn:xmpp:dataforms:softwareinfo");
        df.addField((FormField)ff.build());
        ff = FormField.textMultiBuilder((String)"ip_version");
        ff.addValue((CharSequence)"ipv4");
        ff.addValue((CharSequence)"ipv6");
        df.addField((FormField)ff.build());
        ff = FormField.builder((String)"os_version");
        ff.setValue((CharSequence)"10.5.1");
        df.addField((FormField)ff.build());
        ff = FormField.builder((String)"software");
        ff.setValue((CharSequence)"Psi");
        df.addField((FormField)ff.build());
        ff = FormField.builder((String)"software_version");
        ff.setValue((CharSequence)"0.11");
        df.addField((FormField)ff.build());
        return df.build();
    }

    private static DataForm createSampleServerInfoDataForm() {
        DataForm.Builder df = DataForm.builder((DataForm.Type)DataForm.Type.result);
        TextMultiFormField.Builder ff = FormField.textMultiBuilder((String)"admin-addresses");
        ff.addValue((CharSequence)"xmpp:admin@example.org");
        ff.addValue((CharSequence)"mailto:admin@example.com");
        df.addField((FormField)ff.build());
        ff = FormField.hiddenBuilder((String)"FORM_TYPE");
        ff.setValue((CharSequence)"http://jabber.org/network/serverinfo");
        df.addField((FormField)ff.build());
        return df.build();
    }

    private static DiscoverInfoBuilder createSimpleSampleBuilder() throws XmppStringprepException {
        DiscoverInfoBuilder di = DiscoverInfo.builder((String)"disco1");
        di.ofType(IQ.Type.result);
        di.addIdentity(new DiscoverInfo.Identity("client", "Exodus 0.9.1", "pc"));
        di.addFeature("http://jabber.org/protocol/disco#info");
        di.addFeature("http://jabber.org/protocol/disco#items");
        di.addFeature("http://jabber.org/protocol/muc");
        di.addFeature("http://jabber.org/protocol/caps");
        return di;
    }

    private static DiscoverInfo createSimpleSamplePacket() throws XmppStringprepException {
        return EntityCapsManagerTest.createSimpleSampleBuilder().build();
    }

    private static DiscoverInfo createComplexSamplePacket() throws XmppStringprepException {
        DiscoverInfoBuilder di = DiscoverInfo.builder((String)"disco1");
        di.from(JidCreate.from((String)"benvolio@capulet.lit/230193"));
        di.to(JidCreate.from((String)"juliet@capulet.lit/chamber"));
        di.ofType(IQ.Type.result);
        ArrayList<DiscoverInfo.Identity> identities = new ArrayList<DiscoverInfo.Identity>();
        DiscoverInfo.Identity i = new DiscoverInfo.Identity("client", "pc", "Psi 0.11", "en");
        identities.add(i);
        i = new DiscoverInfo.Identity("client", "pc", "\u03a8 0.11", "el");
        identities.add(i);
        di.addIdentities(identities);
        di.addFeature("http://jabber.org/protocol/disco#items");
        di.addFeature("http://jabber.org/protocol/caps");
        di.addFeature("http://jabber.org/protocol/muc");
        di.addFeature("http://jabber.org/protocol/disco#info");
        DataForm softwareInfoDataForm = EntityCapsManagerTest.createSampleSoftwareInfoDataForm();
        di.addExtension((XmlElement)softwareInfoDataForm);
        return di.build();
    }

    private static DiscoverInfo createMalformedDiscoverInfo() throws XmppStringprepException {
        DiscoverInfoBuilder di = DiscoverInfo.builder((String)"disco1");
        di.from((CharSequence)"benvolio@capulet.lit/230193");
        di.to((CharSequence)")juliet@capulet.lit/chamber");
        di.ofType(IQ.Type.result);
        ArrayList<DiscoverInfo.Identity> identities = new ArrayList<DiscoverInfo.Identity>();
        DiscoverInfo.Identity i = new DiscoverInfo.Identity("client", "pc", "Psi 0.11", "en");
        identities.add(i);
        i = new DiscoverInfo.Identity("client", "pc", "\u03a8 0.11", "el");
        identities.add(i);
        di.addIdentities(identities);
        i = new DiscoverInfo.Identity("client", "pc", "\u03a8 0.11", "el");
        identities.add(i);
        di.addIdentities(identities);
        di.addFeature("http://jabber.org/protocol/disco#items");
        di.addFeature("http://jabber.org/protocol/caps");
        di.addFeature("http://jabber.org/protocol/muc");
        di.addFeature("http://jabber.org/protocol/disco#info");
        di.addFeature("http://jabber.org/protocol/disco#info");
        DataForm softwareInfoDataForm = EntityCapsManagerTest.createSampleSoftwareInfoDataForm();
        di.addExtension((XmlElement)softwareInfoDataForm);
        DiscoverInfo discoverInfo = di.buildWithoutValidiation();
        return discoverInfo;
    }

    public static File createTempDirectory() throws IOException {
        File tmp = File.createTempFile("entity", "caps");
        tmp.delete();
        tmp.mkdir();
        return tmp;
    }
}

